/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.ExceptionMapper;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.exception.ErrorTypeRepositoryFactory;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.manager.ExtensionErrorsRegistrant;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ExtensionErrorsRegistrantTestCase
extends AbstractMuleTestCase {
    private static final String TEST_EXTENSION_NAME = "Test Extension";
    private static final String EXTENSION_PREFIX = "test-namespace";
    private static final String ERROR_PREFIX = "test-namespace".toUpperCase();
    private static final String OPERATION_NAME = "operationName";
    private static final String TEST_CONNECTIVITY_ERROR_TYPE = "TEST_CONNECTIVITY";
    private static final String OAUTH_TEST_CONNECTIVITY_ERROR_TYPE = "OAUTH_CONNECTIVITY";
    private static final String MULE = "MULE";
    private static final String ANY = "ANY";
    private static final ComponentIdentifier OPERATION_IDENTIFIER = ComponentIdentifier.builder().name(NameUtils.hyphenize((String)"operationName")).namespace("test-namespace").build();
    private static final ErrorModel MULE_CONNECTIVITY_ERROR = ErrorModelBuilder.newError((String)"CONNECTIVITY", (String)"MULE").build();
    private static final ErrorModel extensionConnectivityError = ErrorModelBuilder.newError((String)"TEST_CONNECTIVITY", (String)ERROR_PREFIX).withParent(MULE_CONNECTIVITY_ERROR).build();
    private static final ErrorModel oauthExtensionConnectivityError = ErrorModelBuilder.newError((String)"OAUTH_CONNECTIVITY", (String)ERROR_PREFIX).withParent(extensionConnectivityError).build();
    private static final ErrorModel customErrorModel = ErrorModelBuilder.newError((String)"CUSTOM", (String)"MULE").withParent(ErrorModelBuilder.newError((String)"ANY", (String)"MULE").build()).build();
    @Mock
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationWithError;
    @Mock
    private OperationModel operationWithoutErrors;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private ExtensionErrorsRegistrant errorsRegistrant;
    private MuleContext muleContext = MuleContextUtils.mockContextWithServices();
    private ErrorTypeRepository typeRepository;
    private ErrorTypeLocator typeLocator;

    @Before
    public void setUp() {
        XmlDslModel.XmlDslModelBuilder builder = XmlDslModel.builder();
        builder.setPrefix(EXTENSION_PREFIX);
        XmlDslModel xmlDslModel = builder.build();
        this.typeRepository = ErrorTypeRepositoryFactory.createDefaultErrorTypeRepository();
        this.typeLocator = ErrorTypeLocatorFactory.createDefaultErrorTypeLocator((ErrorTypeRepository)this.typeRepository);
        Mockito.when((Object)this.muleContext.getErrorTypeRepository()).thenReturn((Object)this.typeRepository);
        Mockito.when((Object)((PrivilegedMuleContext)this.muleContext).getErrorTypeLocator()).thenReturn((Object)this.typeLocator);
        this.errorsRegistrant = new ExtensionErrorsRegistrant(this.muleContext.getErrorTypeRepository(), ((PrivilegedMuleContext)this.muleContext).getErrorTypeLocator());
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationWithError, this.operationWithoutErrors));
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)xmlDslModel);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)TEST_EXTENSION_NAME);
        Mockito.when((Object)this.operationWithError.getErrorModels()).thenReturn(Collections.singleton(extensionConnectivityError));
        Mockito.when((Object)this.operationWithError.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.operationWithError.getModelProperty((Class)Matchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationWithoutErrors.getName()).thenReturn((Object)"operationWithoutError");
        Mockito.when((Object)this.operationWithoutErrors.getErrorModels()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.operationWithoutErrors.getModelProperty((Class)Matchers.any())).thenReturn(Optional.empty());
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationWithError, this.operationWithoutErrors});
    }

    @Test
    public void lookupErrorsForOperation() {
        Mockito.when((Object)this.extensionModel.getErrorModels()).thenReturn(Collections.singleton(extensionConnectivityError));
        this.errorsRegistrant.registerErrors(this.extensionModel);
        ErrorType errorType = this.typeLocator.lookupComponentErrorType(OPERATION_IDENTIFIER, ConnectionException.class);
        MatcherAssert.assertThat((Object)errorType.getIdentifier(), (Matcher)CoreMatchers.is((Object)"CONNECTIVITY"));
        MatcherAssert.assertThat((Object)errorType.getNamespace(), (Matcher)CoreMatchers.is((Object)EXTENSION_PREFIX.toUpperCase()));
        ErrorType muleConnectivityError = errorType.getParentErrorType();
        MatcherAssert.assertThat((Object)muleConnectivityError.getNamespace(), (Matcher)CoreMatchers.is((Object)MULE_CONNECTIVITY_ERROR.getNamespace()));
        MatcherAssert.assertThat((Object)muleConnectivityError.getIdentifier(), (Matcher)CoreMatchers.is((Object)MULE_CONNECTIVITY_ERROR.getType()));
        ErrorType anyErrorType = muleConnectivityError.getParentErrorType();
        MatcherAssert.assertThat((Object)anyErrorType.getNamespace(), (Matcher)CoreMatchers.is((Object)MULE));
        MatcherAssert.assertThat((Object)anyErrorType.getIdentifier(), (Matcher)CoreMatchers.is((Object)ANY));
        MatcherAssert.assertThat((Object)anyErrorType.getParentErrorType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void registerErrorTypes() {
        Mockito.when((Object)this.extensionModel.getErrorModels()).thenReturn(Collections.singleton(oauthExtensionConnectivityError));
        this.errorsRegistrant.registerErrors(this.extensionModel);
        Optional optionalOAuthType = this.typeRepository.lookupErrorType(ComponentIdentifier.builder().name(OAUTH_TEST_CONNECTIVITY_ERROR_TYPE).namespace(EXTENSION_PREFIX).build());
        Optional optionalConnectivityType = this.typeRepository.lookupErrorType(ComponentIdentifier.builder().name(TEST_CONNECTIVITY_ERROR_TYPE).namespace(EXTENSION_PREFIX).build());
        MatcherAssert.assertThat((Object)optionalOAuthType.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)optionalConnectivityType.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ErrorType parentErrorType = ((ErrorType)optionalOAuthType.get()).getParentErrorType();
        MatcherAssert.assertThat((Object)parentErrorType, (Matcher)CoreMatchers.is(optionalConnectivityType.get()));
    }

    @Test
    public void operationWithoutErrorsDoesntGenerateComponentMapper() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationWithoutErrors));
        ErrorTypeLocator mockTypeLocator = (ErrorTypeLocator)Mockito.mock(ErrorTypeLocator.class);
        this.errorsRegistrant = new ExtensionErrorsRegistrant(this.typeRepository, mockTypeLocator);
        this.errorsRegistrant.registerErrors(this.extensionModel);
        ((ErrorTypeLocator)Mockito.verify((Object)mockTypeLocator, (VerificationMode)Mockito.times((int)0))).addComponentExceptionMapper((ComponentIdentifier)Matchers.any(), (ExceptionMapper)Matchers.any());
    }

    @Test
    public void operationTriesToAddInternalErrorType() {
        ErrorTypeRepository repository = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
        Mockito.when((Object)repository.getErrorType((ComponentIdentifier)Matchers.any())).then(e -> this.typeRepository.getErrorType((ComponentIdentifier)e.getArguments()[0]));
        ErrorModel internalRepeatedError = ErrorModelBuilder.newError((ComponentIdentifier)Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_GENERATE).build();
        Mockito.when((Object)this.operationWithError.getErrorModels()).thenReturn(Collections.singleton(internalRepeatedError));
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationWithError));
        Mockito.when((Object)this.extensionModel.getErrorModels()).thenReturn(Collections.singleton(internalRepeatedError));
        ErrorTypeLocator mockTypeLocator = (ErrorTypeLocator)Mockito.mock(ErrorTypeLocator.class);
        this.errorsRegistrant = new ExtensionErrorsRegistrant(this.typeRepository, mockTypeLocator);
        this.errorsRegistrant.registerErrors(this.extensionModel);
        ((ErrorTypeRepository)Mockito.verify((Object)repository, (VerificationMode)Mockito.times((int)0))).addErrorType((ComponentIdentifier)Matchers.any(), (ErrorType)Matchers.any());
    }

    @Test
    public void extensionCantRegisterAMuleErrorType() {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("The extension [Test Extension] tried to register the [MULE:CUSTOM] error with [MULE] namespace, which is not allowed");
        Mockito.when((Object)this.operationWithError.getErrorModels()).thenReturn(Collections.singleton(customErrorModel));
        Mockito.when((Object)this.extensionModel.getErrorModels()).thenReturn(Collections.singleton(customErrorModel));
        this.errorsRegistrant.registerErrors(this.extensionModel);
    }
}

