/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.QueryEntityResolver;
import org.mule.runtime.extension.api.dsql.DsqlParser;
import org.mule.runtime.extension.api.dsql.DsqlQuery;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.module.extension.internal.metadata.DsqlQueryMetadataResolver;
import org.mule.tck.size.SmallTest;
import org.mule.test.metadata.extension.query.MetadataExtensionEntityResolver;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DsqlQueryMetadataResolverTestCase {
    private static final DsqlParser dsqlParser = DsqlParser.getInstance();
    @Mock
    private MetadataContext context;

    @Before
    public void setUp() {
        Mockito.when((Object)this.context.getTypeBuilder()).thenReturn((Object)new BaseTypeBuilder(MetadataFormat.JAVA));
    }

    @Test
    public void getTrimmedOutputMetadata() throws MetadataResolvingException, ConnectionException {
        DsqlQuery dsqlQuery = dsqlParser.parse("dsql:SELECT id FROM Circle WHERE (diameter < 18)");
        MetadataType outputMetadata = this.getQueryMetadataResolver().getOutputType(this.context, (Object)dsqlQuery);
        ObjectType type = this.getAndAssertTypeOf(outputMetadata);
        MatcherAssert.assertThat((Object)type.getFields(), (Matcher)Matchers.hasSize((int)1));
        ObjectFieldType onlyField = (ObjectFieldType)type.getFields().iterator().next();
        MatcherAssert.assertThat((Object)onlyField.getValue(), (Matcher)Is.is((Matcher)Matchers.instanceOf(NumberType.class)));
        MatcherAssert.assertThat((Object)onlyField.getKey().getName().getLocalPart(), (Matcher)Is.is((Object)"id"));
    }

    @Test
    public void getFullOutputMetadata() throws MetadataResolvingException, ConnectionException {
        DsqlQuery dsqlQuery = dsqlParser.parse("dsql:SELECT * FROM Circle WHERE (diameter < 18)");
        MetadataType outputMetadata = this.getQueryMetadataResolver().getOutputType(this.context, (Object)dsqlQuery);
        ObjectType type = this.getAndAssertTypeOf(outputMetadata);
        MatcherAssert.assertThat((Object)type.getFields(), (Matcher)Matchers.hasSize((int)3));
        type.getFields().forEach(f -> {
            String name = f.getKey().getName().getLocalPart();
            MatcherAssert.assertThat((Object)name, (Matcher)Matchers.isIn(Arrays.asList("color", "id", "diameter")));
        });
    }

    private ObjectType getAndAssertTypeOf(MetadataType outputMetadata) {
        MatcherAssert.assertThat((Object)outputMetadata, (Matcher)Is.is((Matcher)Matchers.instanceOf(ObjectType.class)));
        return (ObjectType)outputMetadata;
    }

    private DsqlQueryMetadataResolver getQueryMetadataResolver() {
        NullMetadataResolver outputResolver = new NullMetadataResolver();
        MetadataExtensionEntityResolver entityResolver = new MetadataExtensionEntityResolver();
        return new DsqlQueryMetadataResolver((QueryEntityResolver)entityResolver, (OutputTypeResolver)outputResolver);
    }
}

