/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.internal.AbstractInterceptableContractTestCase;
import org.mule.runtime.module.extension.internal.runtime.execution.InterceptableOperationExecutorWrapper;

public class InterceptableOperationExecutorWrapperTestCase
extends AbstractInterceptableContractTestCase<InterceptableOperationExecutorWrapper> {
    @Mock(extraInterfaces={Lifecycle.class})
    private ComponentExecutor executor;
    @Mock
    private ExecutionContext<OperationModel> executionContext;

    @Override
    protected InterceptableOperationExecutorWrapper createInterceptable() {
        return new InterceptableOperationExecutorWrapper(this.executor, this.getInterceptors());
    }

    @Test
    public void execute() throws Exception {
        ((InterceptableOperationExecutorWrapper)this.interceptable).execute(this.executionContext);
        ((ComponentExecutor)Mockito.verify((Object)this.executor)).execute(this.executionContext);
    }

    @Test
    public void executorInjected() throws Exception {
        ((InterceptableOperationExecutorWrapper)this.interceptable).initialise();
        ((Injector)Mockito.verify((Object)this.injector)).inject((Object)this.executor);
    }

    @Test
    public void executorInitialised() throws Exception {
        ((InterceptableOperationExecutorWrapper)this.interceptable).initialise();
        ((Initialisable)Mockito.verify((Object)((Initialisable)this.executor))).initialise();
    }

    @Test
    public void executorStarted() throws Exception {
        ((InterceptableOperationExecutorWrapper)this.interceptable).start();
        ((Startable)Mockito.verify((Object)((Startable)this.executor))).start();
    }

    @Test
    public void executorStopped() throws Exception {
        ((InterceptableOperationExecutorWrapper)this.interceptable).stop();
        ((Stoppable)Mockito.verify((Object)((Stoppable)this.executor))).stop();
    }

    @Test
    public void executorDisposed() throws Exception {
        ((InterceptableOperationExecutorWrapper)this.interceptable).dispose();
        ((Disposable)Mockito.verify((Object)((Disposable)this.executor))).dispose();
    }
}

