/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutorFactory;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationExecutorFactoryWrapper;
import org.mule.runtime.module.extension.internal.runtime.operation.ReflectiveMethodOperationExecutor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OperationExecutorFactoryWrapperTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ComponentExecutorFactory executorFactory;
    @Mock
    private ComponentExecutor executor;
    private ExecutionContextAdapter ctx;
    private OperationExecutorFactoryWrapper wrapper;

    @Before
    public void before() {
        Mockito.when((Object)this.executor.execute((ExecutionContext)Matchers.any())).thenReturn((Object)Mono.empty());
        this.setupExecutorFactory();
        this.ctx = (ExecutionContextAdapter)Mockito.spy((Object)new DefaultExecutionContext((ExtensionModel)Mockito.mock(ExtensionModel.class), Optional.empty(), Collections.emptyMap(), (ComponentModel)Mockito.mock(ComponentModel.class), (CoreEvent)Mockito.mock(CoreEvent.class), (CursorProviderFactory)Mockito.mock(CursorProviderFactory.class), (StreamingManager)Mockito.mock(StreamingManager.class), (Component)Mockito.mock(Component.class), (RetryPolicyTemplate)Mockito.mock(RetryPolicyTemplate.class), (MuleContext)Mockito.mock(MuleContext.class)));
        this.wrapper = new OperationExecutorFactoryWrapper(this.executorFactory, Collections.emptyList());
    }

    @Test
    public void javaBlockingOperation() throws Exception {
        this.setupJava();
        this.assertOperation(true, true);
    }

    @Test
    public void javaNonBlockingOperation() throws Exception {
        this.setupJava();
        Mockito.when((Object)this.executor.execute((ExecutionContext)Matchers.any())).thenAnswer(invocationOnMock -> {
            ExecutionContextAdapter ctx = (ExecutionContextAdapter)invocationOnMock.getArguments()[0];
            ((CompletionCallback)ctx.getVariable("MULE_COMPLETION_CALLBACK_CONTEXT_PARAM")).success((Result)Mockito.mock(Result.class));
            return Mono.empty();
        });
        this.assertOperation(true, false);
    }

    @Test
    public void nonJavaNonBlockingOperation() throws Exception {
        this.assertOperation(false, false);
    }

    @Test
    public void nonJavaBlockingOperation() throws Exception {
        this.assertOperation(false, true);
    }

    @Test
    public void construct() throws Exception {
        ConstructModel constructModel = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)constructModel.getModelProperty(ImplementingMethodModelProperty.class)).thenReturn(Optional.empty());
        this.wrapper.createExecutor((ComponentModel)constructModel, Collections.emptyMap()).execute((ExecutionContext)this.ctx);
        ((ExecutionContextAdapter)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.never())).setVariable((String)Matchers.eq((Object)"MULE_COMPLETION_CALLBACK_CONTEXT_PARAM"), Matchers.any());
    }

    private void assertOperation(boolean java, boolean blocking) {
        Mono.from((Publisher)this.wrapper.createExecutor((ComponentModel)this.mockOperation(blocking), Collections.emptyMap()).execute((ExecutionContext)this.ctx)).block();
        ((ComponentExecutor)Mockito.verify((Object)this.executor)).execute((ExecutionContext)this.ctx);
        VerificationMode verificationMode = java && !blocking ? Mockito.times((int)1) : Mockito.never();
        ((ExecutionContextAdapter)Mockito.verify((Object)this.ctx, (VerificationMode)verificationMode)).setVariable((String)Matchers.eq((Object)"MULE_COMPLETION_CALLBACK_CONTEXT_PARAM"), Matchers.any());
    }

    private OperationModel mockOperation(boolean blocking) {
        OperationModel operationModel = (OperationModel)Mockito.mock(OperationModel.class);
        Mockito.when((Object)operationModel.isBlocking()).thenReturn((Object)blocking);
        return operationModel;
    }

    private void setupExecutorFactory() {
        Mockito.when((Object)this.executorFactory.createExecutor((ComponentModel)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)this.executor);
    }

    private void setupJava() {
        this.executor = (ComponentExecutor)Mockito.mock(ReflectiveMethodOperationExecutor.class);
        Mockito.when((Object)this.executor.execute((ExecutionContext)Matchers.any())).thenReturn((Object)Mono.empty());
        this.setupExecutorFactory();
    }
}

