/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.module.extension.internal.runtime.resolver.RegistryLookupValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class RegistryLookupValueResolverTestCase
extends AbstractMuleTestCase {
    private static final String KEY = "key";
    private static final String FAKE_KEY = "not there";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private CoreEvent event;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Registry registry;
    private ValueResolver resolver;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.registry.lookupByName(KEY)).thenReturn(Optional.of("Hello World!"));
        Mockito.when((Object)this.registry.lookupByName(FAKE_KEY)).thenReturn(Optional.empty());
        this.resolver = new RegistryLookupValueResolver(KEY);
        ((RegistryLookupValueResolver)this.resolver).setRegistry(this.registry);
    }

    @Test
    public void cache() throws Exception {
        Object value = this.resolver.resolve(ValueResolvingContext.from((CoreEvent)this.event));
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello World!"));
        ((Registry)Mockito.verify((Object)this.registry)).lookupByName(KEY);
    }

    @Test
    public void isDynamic() {
        Assert.assertThat((Object)this.resolver.isDynamic(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullKey() throws MuleException {
        new RegistryLookupValueResolver(null).resolve(ValueResolvingContext.from((CoreEvent)this.testEvent()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void blankKey() throws MuleException {
        new RegistryLookupValueResolver("").resolve(ValueResolvingContext.from((CoreEvent)this.testEvent()));
    }

    @Test(expected=ConfigurationException.class)
    public void nonExistingKey() throws Exception {
        RegistryLookupValueResolver valueResolver = new RegistryLookupValueResolver(FAKE_KEY);
        valueResolver.setRegistry(this.registry);
        valueResolver.resolve(ValueResolvingContext.from((CoreEvent)this.event));
    }
}

