/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ResolverSetTestCase
extends AbstractMuleTestCase {
    private static final String NAME = "MG";
    private static final int AGE = 31;
    private ResolverSet set;
    private Map<ParameterModel, ValueResolver> mapping;
    @Mock
    private CoreEvent event;
    @Mock
    private ValueResolvingContext resolvingContext;
    @Mock
    private MuleContext muleContext;

    @Before
    public void before() throws Exception {
        this.mapping = new LinkedHashMap<ParameterModel, ValueResolver>();
        this.mapping.put(ExtensionsTestUtils.getParameter("myName", String.class), this.getResolver(NAME));
        this.mapping.put(ExtensionsTestUtils.getParameter("age", Integer.class), this.getResolver(31));
        Mockito.when((Object)this.resolvingContext.getEvent()).thenReturn((Object)this.event);
        Mockito.when((Object)this.resolvingContext.getConfig()).thenReturn(Optional.empty());
        this.set = this.buildSet(this.mapping);
    }

    @Test
    public void resolve() throws Exception {
        ResolverSetResult result = this.set.resolve(this.resolvingContext);
        this.assertResult(result, this.mapping);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addNullParameter() throws Exception {
        this.set.add(null, this.getResolver(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void addNullresolver() throws Exception {
        this.set.add("blah", null);
    }

    @Test(expected=IllegalStateException.class)
    public void addRepeatedParameter() throws Exception {
        String parameterName = "name";
        ValueResolver resolver = this.getResolver(NAME);
        this.set.add("name", resolver);
        this.set.add("name", resolver);
    }

    @Test
    public void isNotDynamic() {
        Assert.assertThat((Object)this.set.isDynamic(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void isDynamic() throws Exception {
        ValueResolver resolver = this.getResolver(null);
        Mockito.when((Object)resolver.isDynamic()).thenReturn((Object)true);
        this.set.add("whatever", resolver);
        Assert.assertThat((Object)this.set.isDynamic(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertResult(ResolverSetResult result, Map<ParameterModel, ValueResolver> mapping) throws Exception {
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        for (Map.Entry<ParameterModel, ValueResolver> entry : mapping.entrySet()) {
            Object value = result.get(entry.getKey().getName());
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)entry.getValue().resolve(this.resolvingContext)));
        }
    }

    private ResolverSet buildSet(Map<ParameterModel, ValueResolver> mapping) {
        ResolverSet set = new ResolverSet(this.muleContext);
        mapping.forEach((key, value) -> set.add(key.getName(), value));
        return set;
    }

    private ValueResolver getResolver(Object value) throws Exception {
        return ExtensionsTestUtils.getResolver(value, this.resolvingContext, false, MuleContextAware.class, Lifecycle.class);
    }
}

