/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class SourceConnectionProviderTestCase
extends AbstractMuleTestCase {
    @Mock
    private ConnectionProvider connectionProvider;
    @Mock
    private ConfigurationInstance configurationInstance;
    @Mock
    private Object configurationObject;
    @Mock
    private Object connection;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    private SourceConnectionProvider sourceConnectionProvider;
    private ConnectionManager connectionManager;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.configurationInstance.getValue()).thenReturn(this.configurationObject);
        this.connectionManager = new DefaultConnectionManager(this.muleContext);
        this.connectionManager.bind(this.configurationObject, this.connectionProvider);
        this.sourceConnectionProvider = new SourceConnectionProvider(new SourceConnectionManager(this.connectionManager), this.configurationInstance);
        Mockito.when((Object)this.connectionProvider.connect()).thenReturn(this.connection);
    }

    @Test
    public void testConnection() throws Exception {
        Object testeableConnection = this.sourceConnectionProvider.connect();
        Assert.assertThat((Object)testeableConnection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)testeableConnection)));
        ((ConnectionProvider)Mockito.verify((Object)this.connectionProvider, (VerificationMode)Mockito.never())).validate(testeableConnection);
        this.sourceConnectionProvider.validate(testeableConnection);
        ((ConnectionProvider)Mockito.verify((Object)this.connectionProvider)).validate(testeableConnection);
    }
}

