/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.DefaultStreamingManager;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.object.InMemoryCursorIteratorConfig;
import org.mule.runtime.core.internal.streaming.object.factory.InMemoryCursorIteratorProviderFactory;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.module.extension.internal.runtime.streaming.DefaultStreamingHelper;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultStreamingHelperTestCase
extends AbstractMuleContextTestCase {
    private StreamingHelper streamingHelper;
    private StreamingManager streamingManager;
    private CursorProviderFactory cursorProviderFactory;
    private CoreEvent event;
    private List<String> valueList = Arrays.asList("Apple", "Banana", "Kiwi");

    protected void doSetUp() throws Exception {
        this.streamingManager = new DefaultStreamingManager();
        LifecycleUtils.initialiseIfNeeded((Object)this.streamingManager, (boolean)true, (MuleContext)muleContext);
        this.cursorProviderFactory = new InMemoryCursorIteratorProviderFactory(InMemoryCursorIteratorConfig.getDefault(), this.streamingManager);
        this.event = this.testEvent();
        this.streamingHelper = new DefaultStreamingHelper(this.cursorProviderFactory, this.streamingManager, this.event);
    }

    protected void doTearDown() throws Exception {
        if (this.streamingManager != null) {
            ((Disposable)this.streamingManager).dispose();
        }
    }

    @Test
    public void resolveIteratorProvider() {
        CursorIteratorProvider streamProvider = (CursorIteratorProvider)this.streamingHelper.resolveCursorProvider(this.valueList.iterator());
        CursorIterator cursor = (CursorIterator)streamProvider.openCursor();
        this.valueList.forEach(value -> {
            Assert.assertThat((Object)cursor.hasNext(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)cursor.next()));
        });
        Assert.assertThat((Object)cursor.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void resolveStreamableTypedValueProvider() {
        TypedValue typedValue = new TypedValue((Object)new ByteArrayInputStream("Apple".getBytes()), DataType.INPUT_STREAM);
        TypedValue repeatableTypedValue = (TypedValue)this.streamingHelper.resolveCursorProvider((Object)typedValue);
        Assert.assertThat((Object)repeatableTypedValue.getValue(), (Matcher)CoreMatchers.instanceOf(CursorProvider.class));
    }

    @Test
    public void resolveNonStreamableTypedValueProvider() {
        TypedValue typedValue = new TypedValue((Object)"Apple", DataType.STRING);
        TypedValue repeatableTypedValue = (TypedValue)this.streamingHelper.resolveCursorProvider((Object)typedValue);
        Assert.assertThat((Object)repeatableTypedValue.getValue(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(CursorProvider.class)));
    }
}

