/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.internal.loader.validator.ParameterModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ParameterModelValidatorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private ParameterModel validParameterModel;
    @Mock
    private ParameterModel invalidParameterModel;
    private ParameterModelValidator validator = new ParameterModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        ExtensionsTestUtils.mockSubTypes(this.extensionModel, new SubTypesModel[0]);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"extensionModel");
        Mockito.when((Object)this.extensionModel.getImportedTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("ns").setNamespace("http://www.mulesoft.org/schema/mule/ns").setSchemaLocation("http://www.mulesoft.org/schema/mule/heisenberg/current/mule-ns.xsd").build());
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"dummyOperation");
        Mockito.when((Object)this.validParameterModel.getModelProperty(ParameterGroupModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.validParameterModel.getModelProperty(QNameModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.validParameterModel.getModelProperty(InfrastructureParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.validParameterModel.getModelProperty(OAuthParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.validParameterModel.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.validParameterModel.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.validParameterModel.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getModelProperty(ParameterGroupModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getModelProperty(QNameModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getModelProperty(InfrastructureParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getModelProperty(OAuthParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.invalidParameterModel.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.invalidParameterModel.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.invalidParameterModel.getLayoutModel()).thenReturn(Optional.empty());
    }

    @Test
    public void validModel() {
        Mockito.when((Object)this.validParameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(String.class));
        Mockito.when((Object)this.validParameterModel.getName()).thenReturn((Object)"url");
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.validParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidModelDueToDefaultValueWhenRequired() {
        Mockito.when((Object)this.invalidParameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(String.class));
        Mockito.when((Object)this.invalidParameterModel.isRequired()).thenReturn((Object)true);
        Mockito.when((Object)this.invalidParameterModel.getName()).thenReturn((Object)"url");
        Mockito.when((Object)this.invalidParameterModel.getDefaultValue()).thenReturn((Object)"default");
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.invalidParameterModel);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }
}

