/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.model.PersonalInfo;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultObjectBuilderTestCase
extends AbstractMuleTestCase {
    private static Class<?> PROTOTYPE_CLASS = PersonalInfo.class;
    private static final String NAME = "heisenberg";
    private static final int AGE = 50;
    @Mock
    private CoreEvent event;
    @Mock
    private ValueResolvingContext resolvingContext;
    @Mock
    private MuleContext muleContext;
    private ReflectionCache reflectionCache = new ReflectionCache();
    private DefaultObjectBuilder<PersonalInfo> builder;
    private Field nameField;
    private Field ageField;
    private Field lifetimeInfoField;
    private List<ValueResolver> resolvers = new ArrayList<ValueResolver>();

    @Before
    public void before() {
        this.builder = new DefaultObjectBuilder(PROTOTYPE_CLASS);
        this.nameField = (Field)IntrospectionUtils.getField(PROTOTYPE_CLASS, (String)"name", (ReflectionCache)this.reflectionCache).get();
        this.ageField = (Field)IntrospectionUtils.getField(PROTOTYPE_CLASS, (String)"age", (ReflectionCache)this.reflectionCache).get();
        Mockito.when((Object)this.resolvingContext.getEvent()).thenReturn((Object)this.event);
        Mockito.when((Object)this.resolvingContext.getConfig()).thenReturn(Optional.empty());
    }

    @Test
    public void build() throws Exception {
        this.populate(false);
        PersonalInfo personalInfo = (PersonalInfo)this.builder.build(this.resolvingContext);
        this.verify(personalInfo);
    }

    @Test
    public void reusable() throws Exception {
        this.populate(false);
        PersonalInfo info1 = (PersonalInfo)this.builder.build(this.resolvingContext);
        PersonalInfo info2 = (PersonalInfo)this.builder.build(this.resolvingContext);
        PersonalInfo info3 = (PersonalInfo)this.builder.build(this.resolvingContext);
        Assert.assertThat((Object)info1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)info2))));
        Assert.assertThat((Object)info1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)info3))));
        this.verify(info1);
        this.verify(info2);
        this.verify(info3);
    }

    private void verify(PersonalInfo personalInfo) {
        Assert.assertThat((Object)personalInfo.getName(), (Matcher)CoreMatchers.is((Object)NAME));
        Assert.assertThat((Object)personalInfo.getAge(), (Matcher)CoreMatchers.is((Object)50));
    }

    @Test
    public void isStatic() throws Exception {
        this.populate(false);
        Assert.assertThat((Object)this.builder.isDynamic(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void isDynamic() throws Exception {
        this.builder.addPropertyResolver(this.nameField.getName(), this.getResolver(NAME, false));
        this.builder.addPropertyResolver(this.ageField.getName(), this.getResolver(50, true));
        Assert.assertThat((Object)this.builder.isDynamic(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void buildInterface() throws Exception {
        this.builder = new DefaultObjectBuilder(InternalMessage.class);
        this.builder.build(this.resolvingContext);
    }

    @Test(expected=IllegalArgumentException.class)
    public void abstractClass() throws Exception {
        this.builder = new DefaultObjectBuilder(TestAbstract.class);
        this.builder.build(this.resolvingContext);
    }

    @Test(expected=IllegalArgumentException.class)
    public void noDefaultConstructor() throws Exception {
        this.builder = new DefaultObjectBuilder(TestNoDefaultConstructor.class);
        this.builder.build(this.resolvingContext);
    }

    @Test(expected=IllegalArgumentException.class)
    public void noPublicConstructor() throws Exception {
        this.builder = new DefaultObjectBuilder(NoPublicConstructor.class);
        this.builder.build(this.resolvingContext);
    }

    private void populate(boolean dynamic) throws Exception {
        this.builder.addPropertyResolver(this.nameField.getName(), this.getResolver(NAME, dynamic));
        this.builder.addPropertyResolver(this.ageField.getName(), this.getResolver(50, dynamic));
    }

    private ValueResolver getResolver(Object value, boolean dynamic) throws Exception {
        ValueResolver resolver = ExtensionsTestUtils.getResolver(value, this.resolvingContext, dynamic, new Class[0]);
        this.resolvers.add(resolver);
        return resolver;
    }

    public static class NoPublicConstructor {
        protected NoPublicConstructor() {
        }
    }

    public static class TestNoDefaultConstructor {
        public TestNoDefaultConstructor(String value) {
        }
    }

    private static abstract class TestAbstract {
        private TestAbstract() {
        }
    }
}

