/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.DefaultStreamingManager;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandlerFactory;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutorFactory;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldOperationParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.InterceptorsModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.QueryParameterModelProperty;
import org.mule.runtime.module.extension.internal.runtime.exception.NullExceptionHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;
import org.mule.test.metadata.extension.resolver.TestNoConfigMetadataResolver;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import reactor.core.publisher.Mono;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class AbstractOperationMessageProcessorTestCase
extends AbstractMuleContextTestCase {
    protected static final String EXTENSION_NAMESPACE = "extension_namespace";
    protected static final String CONFIG_NAME = "config";
    protected static final String OPERATION_NAME = "operation";
    protected static final String TARGET_VAR = "myFlowVar";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected ConfigurationModel configurationModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected OperationModel operationModel;
    @Mock
    protected ExtensionManager extensionManager;
    @Mock
    protected ConnectionManagerAdapter connectionManagerAdapter;
    @Mock
    protected ComponentExecutorFactory operationExecutorFactory;
    @Mock(extraInterfaces={Lifecycle.class, MuleContextAware.class})
    protected ComponentExecutor operationExecutor;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected ResolverSet resolverSet;
    @Mock
    protected ResolverSetResult parameters;
    protected CoreEvent event;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected InternalMessage message;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected MuleContextWithRegistries context;
    @Mock
    protected ConfigurationInstance configurationInstance;
    @Mock
    protected Object configuration;
    @Mock
    protected ExceptionHandlerFactory exceptionHandlerFactory;
    @Mock
    protected MetadataResolverFactory metadataResolverFactory;
    @Mock
    protected ConnectionProviderWrapper connectionProviderWrapper;
    @Mock
    protected ParameterModel contentMock;
    @Mock
    protected ParameterModel keyParamMock;
    @Mock
    protected OutputModel outputMock;
    @Mock
    protected StringType stringType;
    @Mock
    protected ConfigurationProvider configurationProvider;
    protected ParameterGroupModel parameterGroupModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected PolicyManager mockPolicyManager;
    @Mock
    private ExecutionContextAdapter<OperationModel> executionContext;
    protected OperationMessageProcessor messageProcessor;
    protected CursorStreamProviderFactory cursorStreamProviderFactory;
    protected String configurationName = "config";
    protected String target = "";
    protected String targetValue = "#[message]";
    protected OperationPolicy mockOperationPolicy;
    protected StreamingManager streamingManager = (StreamingManager)Mockito.spy((Object)new DefaultStreamingManager());

    @Before
    public void before() throws Exception {
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject("_muleStreamingManager", (Object)this.streamingManager);
        this.cursorStreamProviderFactory = (CursorStreamProviderFactory)Mockito.spy((Object)ExtensionsTestUtils.getDefaultCursorStreamProviderFactory(this.streamingManager));
        this.event = this.configureEvent();
        Mockito.when((Object)this.context.getInjector().inject(Matchers.any())).thenAnswer(invocationOnMock -> {
            Object subject = invocationOnMock.getArguments()[0];
            muleContext.getInjector().inject(subject);
            return subject;
        });
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)EXTENSION_NAMESPACE);
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Arrays.asList(this.configurationModel));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)((Object)((Object)this)).getClass().getName());
        Mockito.when((Object)this.operationModel.isBlocking()).thenReturn((Object)true);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("test-extension").build());
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)new ImmutableOutputModel("Message.Payload", ExtensionsTestUtils.toMetadataType(String.class), false, Collections.emptySet()));
        ExtensionsTestUtils.mockExecutorFactory(this.operationModel, this.operationExecutorFactory);
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel});
        Mockito.when((Object)this.operationModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(new MetadataKeyIdModelProperty(ExtensionsTypeLoaderFactory.getDefault().createTypeLoader().load(String.class), "someParam")));
        ExtensionsTestUtils.setRequires((EnrichableModel)this.operationModel, true, true);
        Mockito.when((Object)this.operationExecutorFactory.createExecutor((ComponentModel)Matchers.same((Object)this.operationModel), Matchers.anyMap())).thenReturn((Object)this.operationExecutor);
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.operationModel.getDisplayModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationModel.getModelProperty(MediaTypeModelProperty.class)).thenReturn(Optional.empty());
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, this.exceptionHandlerFactory);
        Mockito.when((Object)this.exceptionHandlerFactory.createHandler()).thenReturn((Object)new NullExceptionHandler());
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.operationModel, this.metadataResolverFactory);
        Mockito.when((Object)this.metadataResolverFactory.getKeyResolver()).thenReturn((Object)new TestNoConfigMetadataResolver());
        Mockito.when((Object)this.metadataResolverFactory.getInputResolver("content")).thenReturn((Object)new TestNoConfigMetadataResolver());
        Mockito.when((Object)this.metadataResolverFactory.getInputResolver("type")).thenReturn((Object)new NullMetadataResolver());
        Mockito.when((Object)this.metadataResolverFactory.getOutputResolver()).thenReturn((Object)new TestNoConfigMetadataResolver());
        Mockito.when((Object)this.metadataResolverFactory.getOutputAttributesResolver()).thenReturn((Object)new TestNoConfigMetadataResolver());
        Mockito.when((Object)this.metadataResolverFactory.getQueryEntityResolver()).thenReturn((Object)new TestNoConfigMetadataResolver());
        Mockito.when((Object)this.keyParamMock.getName()).thenReturn((Object)"type");
        Mockito.when((Object)this.keyParamMock.getType()).thenReturn((Object)this.stringType);
        Mockito.when((Object)this.keyParamMock.getModelProperty(MetadataKeyPartModelProperty.class)).thenReturn(Optional.of(new MetadataKeyPartModelProperty(1)));
        Mockito.when((Object)this.keyParamMock.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)this.keyParamMock.getDisplayModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.keyParamMock.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.keyParamMock.getModelProperty(QueryParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.keyParamMock.getModelProperty(FieldOperationParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.contentMock.getName()).thenReturn((Object)"content");
        Mockito.when((Object)this.contentMock.hasDynamicType()).thenReturn((Object)true);
        Mockito.when((Object)this.contentMock.getType()).thenReturn((Object)this.stringType);
        Mockito.when((Object)this.contentMock.getRole()).thenReturn((Object)ParameterRole.CONTENT);
        Mockito.when((Object)this.contentMock.getDisplayModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.contentMock.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.contentMock.getModelProperty(MetadataKeyPartModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.contentMock.getModelProperty(QueryParameterModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.contentMock.getModelProperty(FieldOperationParameterModelProperty.class)).thenReturn(Optional.empty());
        this.parameterGroupModel = ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.keyParamMock, this.contentMock);
        Mockito.when((Object)this.parameterGroupModel.getDisplayModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.parameterGroupModel.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.parameterGroupModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.outputMock.getType()).thenReturn((Object)this.stringType);
        Mockito.when((Object)this.outputMock.hasDynamicType()).thenReturn((Object)true);
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)this.outputMock);
        Mockito.when((Object)this.operationModel.getOutputAttributes()).thenReturn((Object)this.outputMock);
        Mockito.when((Object)this.operationModel.getModelProperty(InterceptorsModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationExecutorFactory.createExecutor((ComponentModel)Matchers.same((Object)this.operationModel), Matchers.anyMap())).thenReturn((Object)this.operationExecutor);
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)Matchers.any())).thenReturn((Object)Mono.just((Object)""));
        Mockito.when((Object)this.resolverSet.resolve(ValueResolvingContext.from((CoreEvent)this.event))).thenReturn((Object)this.parameters);
        Mockito.when((Object)this.configurationInstance.getName()).thenReturn((Object)CONFIG_NAME);
        Mockito.when((Object)this.configurationInstance.getModel()).thenReturn((Object)this.configurationModel);
        Mockito.when((Object)this.configurationInstance.getValue()).thenReturn(this.configuration);
        Mockito.when((Object)this.configurationInstance.getConnectionProvider()).thenReturn(Optional.of(this.connectionProviderWrapper));
        Mockito.when((Object)this.configurationProvider.get((Event)this.event)).thenReturn((Object)this.configurationInstance);
        Mockito.when((Object)this.configurationProvider.getConfigurationModel()).thenReturn((Object)this.configurationModel);
        Mockito.when((Object)this.configurationProvider.getName()).thenReturn((Object)this.configurationName);
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.configurationModel.getOperationModel(OPERATION_NAME)).thenReturn(Optional.of(this.operationModel));
        Mockito.when((Object)this.connectionProviderWrapper.getReconnectionConfig()).thenReturn(Optional.of(ReconnectionConfig.getDefault()));
        Mockito.when((Object)this.connectionProviderWrapper.getRetryPolicyTemplate()).thenReturn((Object)new NoRetryPolicyTemplate());
        ExtensionsTestUtils.mockSubTypes(this.extensionModel, new SubTypesModel[0]);
        ExtensionsTestUtils.mockClassLoaderModelProperty(this.extensionModel, ((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.extensionManager.getConfiguration(Matchers.anyString(), (CoreEvent)Matchers.anyObject())).thenReturn((Object)this.configurationInstance);
        Mockito.when((Object)this.extensionManager.getConfiguration(this.extensionModel, (ComponentModel)this.operationModel, this.event)).thenReturn(Optional.of(this.configurationInstance));
        Mockito.when((Object)this.configurationProvider.get((Event)Matchers.anyObject())).thenReturn((Object)this.configurationInstance);
        Mockito.when((Object)this.extensionManager.getConfigurationProvider(this.extensionModel, (ComponentModel)this.operationModel)).thenReturn(Optional.of(this.configurationProvider));
        Mockito.when((Object)this.extensionManager.getConfigurationProvider(CONFIG_NAME)).thenReturn(Optional.of(this.configurationProvider));
        Mockito.when((Object)this.stringType.getAnnotation((Class)Matchers.anyObject())).thenReturn(Optional.empty());
        Mockito.when((Object)this.mockPolicyManager.createOperationPolicy((Component)Matchers.any(), (CoreEvent)Matchers.any(), (Map)Matchers.any(), (OperationExecutionFunction)Matchers.any())).thenAnswer(invocationOnMock -> {
            if (this.mockOperationPolicy == null) {
                this.mockOperationPolicy = (OperationPolicy)Mockito.mock(OperationPolicy.class);
                Mockito.when((Object)this.mockOperationPolicy.process((CoreEvent)Matchers.any())).thenAnswer(operationPolicyInvocationMock -> ((OperationExecutionFunction)invocationOnMock.getArguments()[3]).execute((Map)invocationOnMock.getArguments()[2], (CoreEvent)invocationOnMock.getArguments()[1]));
            }
            return this.mockOperationPolicy;
        });
        Mockito.when((Object)this.executionContext.getRetryPolicyTemplate()).thenReturn(Optional.empty());
        Mockito.when((Object)this.connectionManagerAdapter.getConnection((Object)Matchers.anyString())).thenReturn(null);
        Mockito.when((Object)this.connectionManagerAdapter.getReconnectionConfigFor((ConnectionProvider)Matchers.any())).thenReturn((Object)ReconnectionConfig.getDefault());
        this.messageProcessor = this.setUpOperationMessageProcessor();
    }

    protected CoreEvent configureEvent() throws Exception {
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue((Object)"test", DataType.builder().mediaType(MediaType.create((String)"*", (String)"*", (Charset)Charset.defaultCharset())).build()));
        Mockito.when((Object)this.message.getAttributes()).thenReturn((Object)new TypedValue(null, DataType.builder().fromObject(null).build()));
        return MuleContextUtils.eventBuilder((MuleContext)muleContext).message((Message)this.message).build();
    }

    protected OperationMessageProcessor setUpOperationMessageProcessor() throws Exception {
        OperationMessageProcessor messageProcessor = this.createOperationMessageProcessor();
        messageProcessor.setMuleContext((MuleContext)this.context);
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject("_muleConnectionManager", (Object)this.connectionManagerAdapter);
        muleContext.getInjector().inject((Object)messageProcessor);
        messageProcessor.initialise();
        return messageProcessor;
    }

    protected abstract OperationMessageProcessor createOperationMessageProcessor();

    @Test
    public void initialise() throws Exception {
        ((MuleContextAware)Mockito.verify((Object)((MuleContextAware)this.operationExecutor), (VerificationMode)Mockito.atLeastOnce())).setMuleContext((MuleContext)Matchers.any(MuleContext.class));
        ((Initialisable)Mockito.verify((Object)((Initialisable)this.operationExecutor))).initialise();
    }

    @Test
    public void start() throws Exception {
        this.messageProcessor.start();
        ((Startable)Mockito.verify((Object)((Startable)this.operationExecutor))).start();
    }

    @Test
    public void stop() throws Exception {
        this.messageProcessor.stop();
        ((Stoppable)Mockito.verify((Object)((Stoppable)this.operationExecutor))).stop();
    }

    @Test
    public void dispose() throws Exception {
        this.messageProcessor.dispose();
        ((Disposable)Mockito.verify((Object)((Disposable)this.operationExecutor))).dispose();
    }
}

