/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.defaultanswers.ReturnsDeepStubs;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.module.extension.internal.loader.annotations.CustomDefinedStaticTypeAnnotation;
import org.mule.runtime.module.extension.internal.loader.java.property.CompileTimeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.SourceTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.loader.validation.MediaTypeModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.springframework.core.ResolvableType;

@RunWith(value=MockitoJUnitRunner.class)
public class MediaTypeModelValidatorTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final String EMPTY = "";
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private SourceModel sourceModel;
    @Mock
    private ExtensionTypeDescriptorModelProperty descriptorModelProperty;
    @Mock
    private ExtensionOperationDescriptorModelProperty operationDescriptorModelProperty;
    @Mock
    private OutputModel sourceOutputModel;
    @Mock
    private OutputModel operationOutputModel;
    @Mock
    private MetadataType operationOutputType;
    @Mock
    private MetadataType sourceOutputType;
    private MediaTypeModelValidator validator = new MediaTypeModelValidator();

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Arrays.asList(this.sourceModel));
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getModelProperty(ExtensionTypeDescriptorModelProperty.class)).thenReturn(Optional.of(this.descriptorModelProperty));
        Mockito.when((Object)this.operationModel.getModelProperty(ExtensionOperationDescriptorModelProperty.class)).thenReturn(Optional.of(this.operationDescriptorModelProperty));
        Mockito.when((Object)this.sourceModel.getModelProperty(MediaTypeModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationModel.getModelProperty(MediaTypeModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)this.operationOutputModel);
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)this.sourceOutputModel);
        Mockito.when((Object)this.operationOutputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(Object.class));
        Mockito.when((Object)this.sourceOutputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(Object.class));
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)"source");
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"operation");
        this.mockExtensionOperationDescriptorModelProperty("returnsObject");
        this.mockExtensionTypeDescriptorModelProperty(TestObjectSource.class);
        this.setCompileTime(true);
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel, this.sourceModel});
    }

    private void setCompileTime(boolean compileTime) {
        Mockito.when((Object)this.extensionModel.getModelProperty(CompileTimeModelProperty.class)).thenReturn(Optional.ofNullable(compileTime ? new CompileTimeModelProperty() : null));
    }

    private void mockMediaTypeAnnotation(ConnectableComponentModel model, String value, boolean strict) {
        Mockito.when((Object)model.getModelProperty(MediaTypeModelProperty.class)).thenReturn(Optional.ofNullable(new MediaTypeModelProperty(value, strict)));
    }

    private void mockExtensionTypeDescriptorModelProperty(Class sourceClass) {
        SourceTypeWrapper sourceType = new SourceTypeWrapper(sourceClass, this.typeLoader);
        ExtensionTypeDescriptorModelProperty extensionTypeDescriptorModelProperty = (ExtensionTypeDescriptorModelProperty)Mockito.mock(ExtensionTypeDescriptorModelProperty.class, (Answer)new ReturnsDeepStubs());
        Mockito.when((Object)this.sourceModel.getModelProperty(ExtensionTypeDescriptorModelProperty.class)).thenReturn(Optional.of(extensionTypeDescriptorModelProperty));
        Mockito.when((Object)extensionTypeDescriptorModelProperty.getType()).thenReturn((Object)sourceType);
    }

    private void mockExtensionOperationDescriptorModelProperty(String operationMethodName) throws NoSuchMethodException {
        Method operationMethod = TestMethods.class.getMethod(operationMethodName, new Class[0]);
        TypeWrapper operationReturnType = new TypeWrapper(ResolvableType.forMethodReturnType((Method)operationMethod), this.typeLoader);
        ExtensionOperationDescriptorModelProperty extensionOperationDescriptorModelProperty = (ExtensionOperationDescriptorModelProperty)Mockito.mock(ExtensionOperationDescriptorModelProperty.class, (Answer)new ReturnsDeepStubs());
        Mockito.when((Object)this.operationModel.getModelProperty(ExtensionOperationDescriptorModelProperty.class)).thenReturn(Optional.of(extensionOperationDescriptorModelProperty));
        Mockito.when((Object)extensionOperationDescriptorModelProperty.getOperationReturnType()).thenReturn((Object)operationReturnType);
    }

    @Test
    public void mediaTypeAnnotationMissingOnSourceWithStringOutput() throws Exception {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("'source' has a String type output but doesn't specify a default mime type.");
        this.mockExtensionTypeDescriptorModelProperty(TestStringSource.class);
        Mockito.when((Object)this.sourceOutputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(String.class));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void mediaTypeAnnotationMissingOnSourceWithStreamOutput() throws Exception {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Source 'source' has a InputStream type output but doesn't specify a default mime type.");
        this.mockExtensionTypeDescriptorModelProperty(TestStreamSource.class);
        Mockito.when((Object)this.sourceOutputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(InputStream.class));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void mediaTypeAnnotationMissingOnOperationWithStringOutput() throws Exception {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Operation 'operation' has a String type output but doesn't specify a default mime type.");
        this.mockExtensionOperationDescriptorModelProperty("returnsString");
        Mockito.when((Object)this.operationOutputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(String.class));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void mediaTypeAnnotationMissingOnOperationWithStreamOutput() throws Exception {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Operation 'operation' has a InputStream type output but doesn't specify a default mime type.");
        this.mockExtensionOperationDescriptorModelProperty("returnsStream");
        Mockito.when((Object)this.operationOutputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(InputStream.class));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void mediaTypeAnnotationAndStaticResolverOnOperation() throws Exception {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Operation 'operation' is declaring both a custom output Type using a Static MetadataResolver, and a custom media type through the @MediaType annotation.");
        this.mockExtensionOperationDescriptorModelProperty("returnsString");
        this.mockMediaTypeAnnotation((ConnectableComponentModel)this.operationModel, "*/*", false);
        Mockito.when((Object)this.operationOutputModel.getType()).thenReturn((Object)this.operationOutputType);
        Mockito.when((Object)this.operationOutputType.getAnnotation(CustomDefinedStaticTypeAnnotation.class)).thenReturn(Optional.of(new CustomDefinedStaticTypeAnnotation()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void mediaTypeAnnotationAndStaticResolverOnSource() throws Exception {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Source 'source' is declaring both a custom output Type using a Static MetadataResolver, and a custom media type through the @MediaType annotation.");
        this.mockExtensionTypeDescriptorModelProperty(TestStringSource.class);
        this.mockMediaTypeAnnotation((ConnectableComponentModel)this.sourceModel, "*/*", false);
        Mockito.when((Object)this.sourceOutputModel.getType()).thenReturn((Object)this.sourceOutputType);
        Mockito.when((Object)this.sourceOutputType.getAnnotation(CustomDefinedStaticTypeAnnotation.class)).thenReturn(Optional.of(new CustomDefinedStaticTypeAnnotation()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void mediaTypeAnnotationValueMissingOnOperation() throws Exception {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Operation 'operation' has a String type output but doesn't specify a default mime type.");
        this.mockExtensionOperationDescriptorModelProperty("returnsString");
        this.mockMediaTypeAnnotation((ConnectableComponentModel)this.operationModel, EMPTY, false);
        Mockito.when((Object)this.operationOutputModel.getType()).thenReturn((Object)this.operationOutputType);
        Mockito.when((Object)this.operationOutputType.getAnnotation(CustomDefinedStaticTypeAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationOutputType.getMetadataFormat()).thenReturn((Object)new MetadataFormat("java", "java", new String[]{"application/java"}));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void mediaTypeAnnotationValueMissingOnSource() throws Exception {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Source 'source' has a String type output but doesn't specify a default mime type.");
        this.mockExtensionTypeDescriptorModelProperty(TestStringSource.class);
        this.mockMediaTypeAnnotation((ConnectableComponentModel)this.sourceModel, EMPTY, false);
        Mockito.when((Object)this.sourceOutputModel.getType()).thenReturn((Object)this.sourceOutputType);
        Mockito.when((Object)this.sourceOutputType.getAnnotation(CustomDefinedStaticTypeAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceOutputType.getMetadataFormat()).thenReturn((Object)new MetadataFormat("java", "java", new String[]{"application/java"}));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void mediaTypeAnnotationWithDefaultValueAndStaticResolverOnOperation() throws Exception {
        this.mockExtensionOperationDescriptorModelProperty("returnsString");
        this.mockMediaTypeAnnotation((ConnectableComponentModel)this.operationModel, EMPTY, false);
        Mockito.when((Object)this.operationOutputModel.getType()).thenReturn((Object)this.operationOutputType);
        Mockito.when((Object)this.operationOutputType.getAnnotation(CustomDefinedStaticTypeAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationOutputType.getMetadataFormat()).thenReturn((Object)new MetadataFormat("Xml", "xml", new String[]{"application/xml"}));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void mediaTypeAnnotationWithDefaultValueAndStaticResolverOnSource() throws Exception {
        this.mockExtensionTypeDescriptorModelProperty(TestStringSource.class);
        this.mockMediaTypeAnnotation((ConnectableComponentModel)this.sourceModel, EMPTY, false);
        Mockito.when((Object)this.sourceOutputModel.getType()).thenReturn((Object)this.sourceOutputType);
        Mockito.when((Object)this.sourceOutputType.getAnnotation(CustomDefinedStaticTypeAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceOutputType.getMetadataFormat()).thenReturn((Object)new MetadataFormat("Xml", "xml", new String[]{"application/xml"}));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void mediaTypeAnnotationAndStaticResolverOnOperationInRuntime() throws Exception {
        this.setCompileTime(false);
        this.mockExtensionOperationDescriptorModelProperty("returnsString");
        this.mockMediaTypeAnnotation((ConnectableComponentModel)this.operationModel, "*/*", false);
        Mockito.when((Object)this.operationOutputModel.getType()).thenReturn((Object)this.operationOutputType);
        Mockito.when((Object)this.operationOutputType.getAnnotation(CustomDefinedStaticTypeAnnotation.class)).thenReturn(Optional.of(new CustomDefinedStaticTypeAnnotation()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void mediaTypeAnnotationAndStaticResolverOnSourceInRuntime() throws Exception {
        this.setCompileTime(false);
        this.mockExtensionTypeDescriptorModelProperty(TestStringSource.class);
        this.mockMediaTypeAnnotation((ConnectableComponentModel)this.sourceModel, "*/*", false);
        Mockito.when((Object)this.sourceOutputModel.getType()).thenReturn((Object)this.sourceOutputType);
        Mockito.when((Object)this.sourceOutputType.getAnnotation(CustomDefinedStaticTypeAnnotation.class)).thenReturn(Optional.of(new CustomDefinedStaticTypeAnnotation()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void sourceAndOperationReturnsAnObject() throws Exception {
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    public class TestStreamSource
    extends Source<InputStream, Object> {
        public void onStart(SourceCallback<InputStream, Object> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    public class TestStringSource
    extends Source<String, Object> {
        public void onStart(SourceCallback<String, Object> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    public class TestObjectSource
    extends Source<Object, Object> {
        public void onStart(SourceCallback<Object, Object> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    public class TestMethods {
        public Object returnsObject() {
            return null;
        }

        public String returnsString() {
            return null;
        }

        public InputStream returnsStream() {
            return null;
        }
    }
}

