/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.loader.validation.OperationReturnTypeModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.springframework.core.ResolvableType;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OperationReturnTypeModelValidatorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private MethodElement methodElement;
    private OperationReturnTypeModelValidator validator = new OperationReturnTypeModelValidator();
    private ClassTypeLoader typeLoader = new DefaultExtensionsTypeLoaderFactory().createTypeLoader();

    @Before
    public void before() {
        ExtensionOperationDescriptorModelProperty modelProperty = new ExtensionOperationDescriptorModelProperty(this.methodElement);
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)new ImmutableOutputModel("Message.Payload", ExtensionsTestUtils.toMetadataType(String.class), false, Collections.emptySet()));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"operation");
        Mockito.when((Object)this.operationModel.getModelProperty(ExtensionOperationDescriptorModelProperty.class)).thenReturn(Optional.of(modelProperty));
        Mockito.when((Object)this.methodElement.getReturnType()).thenReturn((Object)new TypeWrapper(String.class, this.typeLoader));
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel});
    }

    @Test
    public void valid() {
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void resultWithoutGenerics() {
        Mockito.when((Object)this.methodElement.getReturnType()).thenReturn((Object)new TypeWrapper(ResolvableType.forType((Type)new TypeToken<Result>(){}.getType()), this.typeLoader));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void resultWithGenerics() {
        Mockito.when((Object)this.methodElement.getReturnType()).thenReturn((Object)new TypeWrapper(ResolvableType.forType((Type)new TypeToken<Result<?, ?>>(){}.getType()), this.typeLoader));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void resultListWithoutGenerics() {
        Mockito.when((Object)this.methodElement.getReturnType()).thenReturn((Object)new TypeWrapper(ResolvableType.forType((Type)new TypeToken<List<Result>>(){}.getType()), this.typeLoader));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void completitionCallbackWithoutGenerics() {
        Mockito.when((Object)this.methodElement.getReturnType()).thenReturn((Object)new TypeWrapper(ResolvableType.forType((Type)new TypeToken<Void>(){}.getType()), this.typeLoader));
        ExtensionParameter completionCallbackParam = (ExtensionParameter)Mockito.mock(ExtensionParameter.class);
        Mockito.when((Object)completionCallbackParam.getType()).thenReturn((Object)new TypeWrapper(ResolvableType.forType((Type)new TypeToken<CompletionCallback>(){}.getType()), this.typeLoader));
        Mockito.when((Object)this.methodElement.getParameters()).thenReturn(Collections.singletonList(completionCallbackParam));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void muleEventReturnType() {
        Mockito.when((Object)this.methodElement.getReturnType()).thenReturn((Object)new TypeWrapper(ResolvableType.forType((Type)new TypeToken<CoreEvent>(){}.getType()), this.typeLoader));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void muleMessageReturnType() {
        Mockito.when((Object)this.methodElement.getReturnType()).thenReturn((Object)new TypeWrapper(ResolvableType.forType((Type)new TypeToken<Message>(){}.getType()), this.typeLoader));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }
}

