/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationProvider;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.TestTimeSupplier;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public abstract class AbstractConfigurationProviderTestCase<T>
extends AbstractMuleContextTestCase {
    protected static final String CONFIG_NAME = "config";
    @Mock
    protected ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected ConfigurationModel configurationModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected DefaultExecutionContext operationContext;
    @Mock
    protected CoreEvent event;
    protected TestTimeSupplier timeSupplier = new TestTimeSupplier(System.currentTimeMillis());
    protected LifecycleAwareConfigurationProvider provider;

    protected Map<String, Object> getStartUpRegistryObjects() {
        return Collections.singletonMap("_muleTimeSupplier", this.timeSupplier);
    }

    @Before
    public void before() throws Exception {
        muleContext.getInjector().inject((Object)this.provider);
        MuleTestUtils.spyInjector((MuleContext)muleContext);
    }

    @Test
    public void getName() {
        Assert.assertThat((Object)this.provider.getName(), (Matcher)CoreMatchers.is((Object)CONFIG_NAME));
    }

    @Test
    public void getConfigurationModel() {
        Assert.assertThat((Object)this.provider.getConfigurationModel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configurationModel)));
    }

    protected void assertSameInstancesResolved() throws Exception {
        int count = 10;
        ConfigurationInstance config = this.provider.get((Event)this.event);
        for (int i = 1; i < 10; ++i) {
            Assert.assertThat((Object)this.provider.get((Event)this.event), (Matcher)CoreMatchers.is((Matcher)Matchers.sameInstance((Object)config)));
        }
    }
}

