/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ConfigurationObjectBuilderTestCase
extends AbstractMuleTestCase {
    private static final String NAME_VALUE = "name";
    private static final String DESCRIPTION_VALUE = "description";
    public static final ParameterModel nameParameterModel = ExtensionsTestUtils.getParameter("name", String.class);
    public static final ParameterModel descriptionParameterModel = ExtensionsTestUtils.getParameter("description", String.class);
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConfigurationModel configurationModel;
    @Mock
    private CoreEvent event;
    private ConfigurationObjectBuilder<TestConfig> configurationObjectBuilder;
    private ResolverSet resolverSet;

    public static ResolverSet createResolverSet() throws Exception {
        ResolverSet resolverSet = new ResolverSet((MuleContext)Mockito.mock(MuleContext.class));
        resolverSet.add(nameParameterModel.getName(), ExtensionsTestUtils.getResolver(NAME_VALUE));
        resolverSet.add(descriptionParameterModel.getName(), ExtensionsTestUtils.getResolver(DESCRIPTION_VALUE));
        return resolverSet;
    }

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.configurationModel.getAllParameterModels()).thenReturn(Arrays.asList(nameParameterModel, descriptionParameterModel));
        ExtensionsTestUtils.mockConfigurationInstance(this.configurationModel, new TestConfig());
        Mockito.when((Object)this.configurationModel.getModelProperty(ParameterGroupModelProperty.class)).thenReturn(Optional.empty());
        this.resolverSet = ConfigurationObjectBuilderTestCase.createResolverSet();
        this.configurationObjectBuilder = new ConfigurationObjectBuilder(this.configurationModel, this.resolverSet);
    }

    @Test
    public void build() throws Exception {
        TestConfig testConfig = (TestConfig)((Pair)this.configurationObjectBuilder.build(ValueResolvingContext.from((CoreEvent)this.event))).getFirst();
        Assert.assertThat((Object)testConfig.getName(), (Matcher)CoreMatchers.is((Object)NAME_VALUE));
        Assert.assertThat((Object)testConfig.getDescription(), (Matcher)CoreMatchers.is((Object)DESCRIPTION_VALUE));
    }

    public static class TestConfig {
        private String name;
        private String description;

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

