/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.spi.work.Work;
import org.assertj.core.api.ThrowableAssert;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.module.extension.internal.runtime.source.AbstractExtensionMessageSourceTestCase;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionMessageSource;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapterFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandlerFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.test.heisenberg.extension.exception.HeisenbergConnectionExceptionEnricher;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@RunWith(value=Parameterized.class)
public class ExtensionMessageSourceTestCase
extends AbstractExtensionMessageSourceTestCase {
    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"primary node only", true}, {"all nodes", false});
    }

    public ExtensionMessageSourceTestCase(String name, boolean primaryNodeOnly) {
        this.primaryNodeOnly = primaryNodeOnly;
    }

    @Test
    public void handleMessage() throws Exception {
        Mockito.reset((Object[])new SourceCallbackFactory[]{this.sourceCallbackFactory});
        Mockito.when((Object)this.sourceCallbackFactory.createSourceCallback((SourceCompletionHandlerFactory)Matchers.any())).thenReturn((Object)this.sourceCallback);
        AtomicBoolean handled = new AtomicBoolean(false);
        ((Source)Mockito.doAnswer(invocationOnMock -> {
            this.sourceCallback.handle(this.result);
            handled.set(true);
            return null;
        }).when((Object)this.source)).onStart(this.sourceCallback);
        ((Scheduler)Mockito.doAnswer(invocation -> {
            ((Work)invocation.getArguments()[0]).run();
            return null;
        }).when((Object)this.cpuLightScheduler)).execute((Runnable)Matchers.any());
        this.start();
        Assert.assertThat((Object)handled.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void handleExceptionAndRestart() throws Exception {
        this.start();
        this.messageSource.onException(new ConnectionException("ERROR"));
        ((Source)Mockito.verify((Object)this.source)).onStop();
        ((Scheduler)Mockito.verify((Object)this.ioScheduler, (VerificationMode)Mockito.never())).stop();
        ((Scheduler)Mockito.verify((Object)this.cpuLightScheduler, (VerificationMode)Mockito.never())).stop();
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)2))).onStart(this.sourceCallback);
    }

    @Test
    public void initialise() throws Exception {
        if (!this.messageSource.getLifecycleState().isInitialised()) {
            this.messageSource.initialise();
            ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.never())).onStart(this.sourceCallback);
        }
    }

    @Test
    public void sourceIsInstantiatedOnce() throws Exception {
        this.initialise();
        this.start();
        ((SourceAdapterFactory)Mockito.verify((Object)this.sourceAdapterFactory, (VerificationMode)Mockito.times((int)1))).createAdapter((Optional)Matchers.any(), (SourceCallbackFactory)Matchers.any(), (Component)Matchers.any(), (SourceConnectionManager)Matchers.any(), (MessagingExceptionResolver)Matchers.any());
    }

    @Test
    public void failToStart() throws Exception {
        ConnectionException connectionException = new ConnectionException("ERROR");
        DefaultMuleException e = new DefaultMuleException((Throwable)connectionException);
        ((Source)Mockito.doThrow((Throwable)e).when((Object)this.source)).onStart((SourceCallback)Matchers.any());
        this.expectedException.expect(CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RetryPolicyExhaustedException.class)));
        this.expectedException.expectCause(CoreMatchers.is((Object)connectionException));
        this.messageSource.initialise();
        this.messageSource.start();
    }

    @Test
    public void failToStartAndStopFails() throws Exception {
        ConnectionException connectionException = new ConnectionException("ERROR");
        DefaultMuleException e = new DefaultMuleException((Throwable)connectionException);
        ((Source)Mockito.doThrow((Throwable)e).when((Object)this.source)).onStart((SourceCallback)Matchers.any());
        ((Source)Mockito.doThrow((Throwable)new NullPointerException()).when((Object)this.source)).onStop();
        this.expectedException.expect(CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RetryPolicyExhaustedException.class)));
        this.expectedException.expectCause(CoreMatchers.is((Object)connectionException));
        this.messageSource.initialise();
        this.messageSource.start();
    }

    @Test
    public void failWithConnectionExceptionWhenStartingAndGetRetryPolicyExhausted() throws Exception {
        this.messageSource.initialise();
        ConnectionException connectionException = new ConnectionException("ERROR");
        ((Source)Mockito.doThrow((Throwable)new RuntimeException((Throwable)connectionException)).when((Object)this.source)).onStart(this.sourceCallback);
        Throwable throwable = ThrowableAssert.catchThrowable(() -> ((ExtensionMessageSource)this.messageSource).start());
        Assert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RetryPolicyExhaustedException.class)));
        Assert.assertThat((Object)throwable, (Matcher)CoreMatchers.is(this.exhaustedBecauseOf((Throwable)connectionException)));
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)3))).onStart(this.sourceCallback);
    }

    @Test
    public void failWithNonConnectionExceptionWhenStartingAndGetRetryPolicyExhausted() throws Exception {
        ((Source)Mockito.doThrow((Throwable)new DefaultMuleException((Throwable)new IOException("ERROR"))).when((Object)this.source)).onStart(this.sourceCallback);
        this.messageSource.initialise();
        Throwable throwable = ThrowableAssert.catchThrowable(() -> ((ExtensionMessageSource)this.messageSource).start());
        Assert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RetryPolicyExhaustedException.class)));
        Assert.assertThat((Object)org.apache.commons.lang3.exception.ExceptionUtils.getThrowables((Throwable)throwable), (Matcher)org.hamcrest.Matchers.hasItemInArray((Matcher)CoreMatchers.instanceOf(IOException.class)));
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)3))).onStart(this.sourceCallback);
    }

    @Test
    public void failWithConnectionExceptionWhenStartingAndGetsReconnected() throws Exception {
        ((Source)Mockito.doThrow((Throwable)new RuntimeException((Throwable)new ConnectionException("ERROR"))).doThrow((Throwable)new RuntimeException((Throwable)new ConnectionException("ERROR"))).doNothing().when((Object)this.source)).onStart(this.sourceCallback);
        this.messageSource.initialise();
        this.messageSource.start();
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)3))).onStart(this.sourceCallback);
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)2))).onStop();
    }

    @Test
    public void getBackPressureStrategy() {
        Assert.assertThat((Object)this.messageSource.getBackPressureStrategy(), (Matcher)CoreMatchers.is((Object)MessageSource.BackPressureStrategy.FAIL));
    }

    @Test
    public void failOnExceptionWithConnectionExceptionAndGetsReconnected() throws Exception {
        this.messageSource.initialise();
        this.messageSource.start();
        this.messageSource.onException(new ConnectionException("ERROR"));
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)2))).onStart(this.sourceCallback);
        ((Source)Mockito.verify((Object)this.source, (VerificationMode)Mockito.times((int)1))).onStop();
    }

    @Test
    public void startFailsWithRandomException() throws Exception {
        final RuntimeException e = new RuntimeException();
        ((Source)Mockito.doThrow((Throwable)e).when((Object)this.source)).onStart(this.sourceCallback);
        this.expectedException.expect(this.exhaustedBecauseOf((Matcher<Throwable>)new BaseMatcher<Throwable>(){
            private Matcher<Exception> exceptionMatcher;
            {
                this.exceptionMatcher = ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.sameInstance((Object)e));
            }

            public boolean matches(Object item) {
                return this.exceptionMatcher.matches(item);
            }

            public void describeTo(Description description) {
                this.exceptionMatcher.describeTo(description);
            }
        }));
        this.initialise();
        this.messageSource.start();
    }

    @Test
    public void start() throws Exception {
        this.initialise();
        if (!this.messageSource.getLifecycleState().isStarted()) {
            this.messageSource.start();
        }
        ((Source)Mockito.verify((Object)this.source)).onStart(this.sourceCallback);
        ((Injector)Mockito.verify((Object)muleContext.getInjector())).inject((Object)this.source);
    }

    @Test
    public void failedToCreateRetryScheduler() throws Exception {
        this.messageSource.initialise();
        RuntimeException e = new RuntimeException();
        SchedulerService schedulerService = muleContext.getSchedulerService();
        ((SchedulerService)Mockito.doThrow((Throwable)e).when((Object)schedulerService)).cpuLightScheduler();
        Throwable throwable = ThrowableAssert.catchThrowable(() -> ((ExtensionMessageSource)this.messageSource).start());
        Assert.assertThat((Object)throwable.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
    }

    @Test
    public void failedToCreateFlowTrigger() throws Exception {
        RuntimeException e = new RuntimeException();
        SchedulerService schedulerService = muleContext.getSchedulerService();
        ((SchedulerService)Mockito.doThrow((Throwable)e).when((Object)schedulerService)).cpuLightScheduler();
        this.messageSource.initialise();
        Throwable throwable = ThrowableAssert.catchThrowable(() -> ((ExtensionMessageSource)this.messageSource).start());
        Assert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LifecycleException.class)));
        Assert.assertThat((Object)throwable.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
    }

    @Test
    public void stop() throws Exception {
        this.messageSource.initialise();
        this.messageSource.start();
        this.messageSource.stop();
        ((Source)Mockito.verify((Object)this.source)).onStop();
    }

    @Test
    public void enrichExceptionWithSourceExceptionEnricher() throws Exception {
        Mockito.when((Object)this.enricherFactory.createHandler()).thenReturn((Object)new HeisenbergConnectionExceptionEnricher());
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.sourceModel, this.enricherFactory);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.sourceModel, this.enricherFactory);
        ExtensionMessageSource messageSource = this.getNewExtensionMessageSourceInstance();
        messageSource.initialise();
        ((Source)Mockito.doThrow((Throwable)new RuntimeException("ERROR")).when((Object)this.source)).onStart(this.sourceCallback);
        Throwable t = ThrowableAssert.catchThrowable(() -> ((ExtensionMessageSource)messageSource).start());
        Assert.assertThat((Object)ExceptionUtils.containsType((Throwable)t, ConnectionException.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)t.getMessage(), (Matcher)StringContains.containsString((String)"Enriched Connection Exception: ERROR"));
        messageSource.stop();
    }

    @Test
    public void enrichExceptionWithExtensionEnricher() throws Exception {
        String enrichedErrorMessage = "Enriched: ERROR";
        ExceptionHandler exceptionEnricher = (ExceptionHandler)Mockito.mock(ExceptionHandler.class);
        Mockito.when((Object)exceptionEnricher.enrichException((Exception)Matchers.any(Exception.class))).thenReturn((Object)new Exception("Enriched: ERROR"));
        Mockito.when((Object)this.enricherFactory.createHandler()).thenReturn((Object)exceptionEnricher);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.extensionModel, this.enricherFactory);
        ExtensionMessageSource messageSource = this.getNewExtensionMessageSourceInstance();
        messageSource.initialise();
        ((Source)Mockito.doThrow((Throwable)new RuntimeException("ERROR")).when((Object)this.source)).onStart(this.sourceCallback);
        Throwable t = ThrowableAssert.catchThrowable(() -> ((ExtensionMessageSource)messageSource).start());
        Assert.assertThat((Object)t.getMessage(), (Matcher)StringContains.containsString((String)"Enriched: ERROR"));
        messageSource.stop();
    }

    @Test
    public void workManagerDisposedIfSourceFailsToStart() throws Exception {
        this.start();
        final RuntimeException e = new RuntimeException();
        ((Source)Mockito.doThrow((Throwable)e).when((Object)this.source)).onStop();
        this.expectedException.expect((Matcher)new BaseMatcher<Throwable>(){

            public boolean matches(Object item) {
                Exception exception = (Exception)item;
                return exception.getCause() instanceof MuleException && exception.getCause().getCause() == e;
            }

            public void describeTo(Description description) {
                description.appendText("Exception was not wrapped as expected");
            }
        });
    }

    private BaseMatcher<Throwable> exhaustedBecauseOf(Throwable cause) {
        return this.exhaustedBecauseOf((Matcher<Throwable>)CoreMatchers.sameInstance((Object)cause));
    }

    private BaseMatcher<Throwable> exhaustedBecauseOf(final Matcher<Throwable> causeMatcher) {
        return new BaseMatcher<Throwable>(){

            public boolean matches(Object item) {
                Throwable exception = (Throwable)item;
                return causeMatcher.matches((Object)exception.getCause());
            }

            public void describeTo(Description description) {
                causeMatcher.describeTo(description);
            }
        };
    }

    @Test
    public void getMetadataKeyIdObjectValue() throws Exception {
        String person = "person";
        this.source = new DummySource("person");
        this.sourceAdapter = this.createSourceAdapter();
        Mockito.when((Object)this.sourceAdapterFactory.createAdapter((Optional)Matchers.any(), (SourceCallbackFactory)Matchers.any(), (Component)Matchers.any(), (SourceConnectionManager)Matchers.any(), (MessagingExceptionResolver)Matchers.any())).thenReturn((Object)this.sourceAdapter);
        this.messageSource = this.getNewExtensionMessageSourceInstance();
        this.messageSource.initialise();
        this.messageSource.start();
        Object metadataKeyValue = this.messageSource.getParameterValueResolver().getParameterValue("metadataKey");
        Assert.assertThat((Object)metadataKeyValue, (Matcher)CoreMatchers.is((Object)"person"));
    }

    private class DummySource
    extends Source {
        private String metadataKey;

        DummySource(String metadataKey) {
            this.metadataKey = metadataKey;
        }

        public void onStart(SourceCallback sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }
}

