/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.execution.ResponseCompletionCallback;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.execution.MessageProcessContext;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionSourceExceptionCallback;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ExtensionSourceExceptionCallbackTestCase
extends AbstractMuleTestCase {
    private CoreEvent event;
    @Mock
    private MessageProcessContext messageProcessContext;
    @Mock
    private ResponseCompletionCallback responseCallback;
    @Mock
    private Consumer<MessagingException> exceptionHandlingCallback;
    @Mock
    private ErrorTypeLocator errorTypeLocator;
    @Mock
    private MessageSource messageSource;
    @Mock
    private ErrorType errorType;
    private ExtensionSourceExceptionCallback callback;
    private Exception exception = new Exception();

    @Before
    public void before() throws MuleException {
        this.event = this.newEvent();
        Mockito.when((Object)this.errorType.getIdentifier()).thenReturn((Object)"ID");
        Mockito.when((Object)this.errorType.getNamespace()).thenReturn((Object)"NS");
        Mockito.when((Object)this.errorTypeLocator.lookupErrorType((Throwable)Matchers.any(Exception.class))).thenReturn((Object)this.errorType);
        Mockito.when((Object)this.messageProcessContext.getErrorTypeLocator()).thenReturn((Object)this.errorTypeLocator);
        Mockito.when((Object)this.messageProcessContext.getMessageSource()).thenReturn((Object)this.messageSource);
        this.callback = new ExtensionSourceExceptionCallback(this.responseCallback, this.event, this.exceptionHandlingCallback, this.messageProcessContext);
    }

    @Test
    public void onException() {
        this.callback.onException((Throwable)this.exception);
        ((ResponseCompletionCallback)Mockito.verify((Object)this.responseCallback)).responseSentWithFailure((MessagingException)Matchers.argThat((Matcher)new ArgumentMatcher<MessagingException>(){

            public boolean matches(Object o) {
                return o instanceof MessagingException && ((MessagingException)o).getRootCause().equals(ExtensionSourceExceptionCallbackTestCase.this.exception);
            }
        }), (CoreEvent)Matchers.argThat((Matcher)new ArgumentMatcher<CoreEvent>(){

            public boolean matches(Object o) {
                return o instanceof CoreEvent && ((CoreEvent)o).getError().isPresent() && ((Error)((CoreEvent)o).getError().get()).getErrorType().equals(ExtensionSourceExceptionCallbackTestCase.this.errorType);
            }
        }));
    }

    @Test
    public void exceptionHandlingCallbackInvoked() {
        ArgumentCaptor exceptionCaptor = ArgumentCaptor.forClass(MessagingException.class);
        this.onException();
        ((Consumer)Mockito.verify(this.exceptionHandlingCallback)).accept(exceptionCaptor.capture());
        MessagingException messagingException = (MessagingException)exceptionCaptor.getValue();
        Assert.assertThat((Object)messagingException, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)messagingException.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.exception)));
    }
}

