/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import com.google.testing.compile.CompilationRule;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import org.apache.commons.collections.CollectionUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MapDataType;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBasket;
import org.mule.tck.testmodels.fruit.FruitBox;
import org.mule.tck.testmodels.fruit.Kiwi;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.petstore.extension.PhoneNumber;
import org.mule.test.petstore.extension.TransactionalPetStoreClient;
import org.mule.test.petstore.extension.TransactionalPetStoreConnectionProvider;
import org.springframework.core.ResolvableType;

@SmallTest
@RunWith(value=Parameterized.class)
public class IntrospectionUtilsTestCase
extends AbstractMuleTestCase {
    private static final String CLASS = "CLASS";
    public static final String OPERATION_RESULT = "operationResult";
    public static final String PAGING_PROVIDER = "pagingProvider";
    public static final String PAGING_PROVIDER_OPERATION_RESULT = "pagingProviderOperationResult";
    public static final String FOO = "foo";
    public static ProcessingEnvironment processingEnvironment;
    private List<FruitBasket> baskets;
    @Rule
    public CompilationRule compilationRule = new CompilationRule();
    private ReflectionCache reflectionCache = new ReflectionCache();
    @Parameterized.Parameter
    public String mode;
    @Parameterized.Parameter(value=1)
    public BiFunction<String, Class[], OperationElement> operationSupplier;
    @Parameterized.Parameter(value=2)
    public Function<Class, Type> typeSupplier;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> objects = new ArrayList<Object[]>();
        Function<Class, Type> javaTypeSupplier = aClass -> new TypeWrapper(aClass, new DefaultExtensionsTypeLoaderFactory().createTypeLoader());
        objects.add(new Object[]{CLASS, new ClassOperationSupplier(), javaTypeSupplier});
        return objects;
    }

    @Before
    public void setUp() {
        processingEnvironment = (ProcessingEnvironment)Mockito.mock(ProcessingEnvironment.class);
        Mockito.when((Object)processingEnvironment.getTypeUtils()).thenReturn((Object)this.compilationRule.getTypes());
        Mockito.when((Object)processingEnvironment.getElementUtils()).thenReturn((Object)this.compilationRule.getElements());
    }

    @Test
    public void getMethodReturnType() throws Exception {
        MetadataType metadataType = IntrospectionUtils.getMethodReturnType((MethodElement)this.getMethod(FOO, new Class[0]));
        this.assertDictionary(metadataType, Apple.class);
    }

    @Test
    public void getOperationResultReturnType() throws Exception {
        this.assertReturnType(OPERATION_RESULT);
        this.assertAttributesType(OPERATION_RESULT);
    }

    @Test
    public void getPagingProviderReturnType() throws Exception {
        this.assertPagingProviderReturnType(PAGING_PROVIDER);
        this.assertVoidAttributesType(PAGING_PROVIDER);
    }

    @Test
    public void getPagingProviderOperationResultReturnType() throws Exception {
        this.assertPagingProviderReturnResultType(PAGING_PROVIDER_OPERATION_RESULT);
        this.assertVoidAttributesType(PAGING_PROVIDER_OPERATION_RESULT);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullMethodReturnType() {
        IntrospectionUtils.getMethodReturnType(null);
    }

    @Test
    public void getArgumentlessMethodArgumentTypes() throws Exception {
        Assume.assumeThat((Object)this.mode, (Matcher)CoreMatchers.is((Object)CLASS));
        MetadataType[] types = IntrospectionUtils.getMethodArgumentTypes((Method)((Method)this.getMethod(FOO, new Class[0]).getMethod().get()), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        junit.framework.Assert.assertNotNull((Object)types);
        junit.framework.Assert.assertEquals((int)0, (int)types.length);
    }

    @Test
    public void getMethodArgumentTypes() throws Exception {
        Assume.assumeThat((Object)this.mode, (Matcher)CoreMatchers.is((Object)CLASS));
        MetadataType[] types = IntrospectionUtils.getMethodArgumentTypes((Method)((Method)this.getMethod("bar", String.class, Long.class, Apple.class, Map.class).getMethod().get()), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        junit.framework.Assert.assertNotNull((Object)types);
        junit.framework.Assert.assertEquals((int)4, (int)types.length);
        this.assertType(types[0], String.class);
        this.assertType(types[1], Long.class);
        this.assertType(types[2], Apple.class);
        this.assertDictionary(types[3], Kiwi.class);
    }

    @Test
    public void getInterfaceGenerics() {
        Type connectionProvider = this.typeSupplier.apply(TransactionalPetStoreConnectionProvider.class);
        List interfaceGenerics = connectionProvider.getInterfaceGenerics(ConnectionProvider.class);
        Assert.assertThat((Object)interfaceGenerics.size(), (Matcher)CoreMatchers.is((Object)1));
        Type type = (Type)interfaceGenerics.get(0);
        Assert.assertThat((Object)type.isSameType(TransactionalPetStoreClient.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void resultWithNoGenericsIsAnyType() throws Exception {
        MetadataType resultWithNoGenerics = this.getMethod("resultWithNoGenerics", new Class[0]).getReturnMetadataType();
        MetadataType resultWithWildcardGenerics = this.getMethod("resultWithWildcardGenerics", new Class[0]).getReturnMetadataType();
        Assert.assertThat((Object)resultWithNoGenerics, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AnyType.class)));
        Assert.assertThat((Object)resultWithWildcardGenerics, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AnyType.class)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullMethodArgumentTypes() throws Exception {
        IntrospectionUtils.getMethodArgumentTypes(null, (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
    }

    @Test
    public void getFieldDataType() throws Exception {
        MetadataType type = IntrospectionUtils.getFieldMetadataType((Field)IntrospectionUtilsTestCase.class.getDeclaredField("baskets"), (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
        this.assertList(type, FruitBasket.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNullFieldDataType() throws Exception {
        IntrospectionUtils.getFieldMetadataType(null, (ClassTypeLoader)ExtensionsTestUtils.TYPE_LOADER);
    }

    @Test
    public void getEmptyExposedPojoFields() {
        Collection exposedFields = IntrospectionUtils.getExposedFields(FruitBasket.class, (ReflectionCache)this.reflectionCache);
        Assert.assertThat((Object)exposedFields, (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void getFieldsWithGettersOnly() {
        Set fieldsWithGetters = IntrospectionUtils.getFieldsWithGetters(PhoneNumber.class, (ReflectionCache)this.reflectionCache);
        Assert.assertThat((Object)fieldsWithGetters.size(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void getRawListReturnTypeNoGenerics() {
        Set fieldsWithGetters = IntrospectionUtils.getFieldsWithGetters(PhoneNumber.class, (ReflectionCache)this.reflectionCache);
        Assert.assertThat((Object)fieldsWithGetters.size(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void getWildCardFieldsDataTypes() {
        Set exposedFields = IntrospectionUtils.getFieldsWithGetters(FruitBox.class, (ReflectionCache)this.reflectionCache);
        junit.framework.Assert.assertNotNull((Object)exposedFields);
        junit.framework.Assert.assertEquals((int)6, (int)exposedFields.size());
        this.assertField("fruitLikeList", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Fruit.class)), exposedFields);
        this.assertField("wildCardList", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Object.class)), exposedFields);
        this.assertField("rawList", (MetadataType)ExtensionsTestUtils.arrayOf(List.class, ExtensionsTestUtils.objectTypeBuilder(Object.class)), exposedFields);
        this.assertField("wildCardMap", (MetadataType)ExtensionsTestUtils.dictionaryOf(ExtensionsTestUtils.objectTypeBuilder(Object.class)), exposedFields);
        this.assertField("rawMap", (MetadataType)ExtensionsTestUtils.dictionaryOf(ExtensionsTestUtils.objectTypeBuilder(Object.class)), exposedFields);
        this.assertField("fruitLikeMap", (MetadataType)ExtensionsTestUtils.dictionaryOf(ExtensionsTestUtils.objectTypeBuilder(Fruit.class)), exposedFields);
    }

    @Test
    public void getDataTypeFromList() {
        Class<List> listClass = List.class;
        Class<Integer> integerClass = Integer.class;
        ArrayTypeBuilder arrayTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType().with((TypeAnnotation)new ClassInformationAnnotation(listClass));
        arrayTypeBuilder.of().numberType().integer();
        CollectionDataType dataType = (CollectionDataType)IntrospectionUtils.toDataType((MetadataType)arrayTypeBuilder.build());
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(listClass)));
        Assert.assertThat((Object)dataType.getItemDataType().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(integerClass)));
    }

    @Test
    public void getDataTypeFromMap() {
        Class<Date> dateClass = Date.class;
        Class<Map> mapClass = Map.class;
        ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class));
        objectTypeBuilder.openWith().objectType().id(dateClass.getName());
        MapDataType dataType = (MapDataType)IntrospectionUtils.toDataType((MetadataType)objectTypeBuilder.build());
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(mapClass)));
        Assert.assertThat((Object)dataType.getKeyDataType().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(String.class)));
        Assert.assertThat((Object)dataType.getValueDataType().getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(dateClass)));
    }

    @Test
    public void getDataTypeFromObject() {
        Class<Object> objectClass = Object.class;
        ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id(objectClass.getName());
        DataType dataType = IntrospectionUtils.toDataType((MetadataType)objectTypeBuilder.build());
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(objectClass)));
    }

    @Test
    public void getDataTypeFromString() {
        StringTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType();
        DataType dataType = IntrospectionUtils.toDataType((MetadataType)typeBuilder.build());
        Assert.assertThat((Object)dataType.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(String.class)));
    }

    @Test
    public void getPagingProviderImplementationTypes() {
        ResolvableType pagingProvider = ResolvableType.forClass(TestPagingProvider.class);
        Pair pagingProviderTypes = IntrospectionUtils.getPagingProviderTypes((Type)new TypeWrapper(pagingProvider, ExtensionsTestUtils.TYPE_LOADER));
        Assert.assertThat(((Type)pagingProviderTypes.getFirst()).getDeclaringClass().get(), (Matcher)CoreMatchers.equalTo(Object.class));
        Assert.assertThat(((Type)pagingProviderTypes.getSecond()).getDeclaringClass().get(), (Matcher)CoreMatchers.equalTo(Result.class));
    }

    @Test
    public void getPagingProviderImplementationTypesReturnType() throws Exception {
        OperationElement getPagingProvider = this.getMethod("getPagingProvider", new Class[0]);
        MetadataType methodReturnType = IntrospectionUtils.getMethodReturnType((MethodElement)getPagingProvider);
        Assert.assertThat((Object)methodReturnType, (Matcher)CoreMatchers.instanceOf(ArrayType.class));
        MetadataType valueType = ((ArrayType)methodReturnType).getType();
        Assert.assertThat((Object)valueType, (Matcher)CoreMatchers.instanceOf(MessageMetadataType.class));
        MessageMetadataType messageType = (MessageMetadataType)valueType;
        MetadataType payloadType = (MetadataType)messageType.getPayloadType().get();
        MetadataType attributesTypes = (MetadataType)messageType.getAttributesType().get();
        Assert.assertThat((Object)((TypeIdAnnotation)payloadType.getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)CoreMatchers.is((Object)Banana.class.getName()));
        Assert.assertThat((Object)((TypeIdAnnotation)attributesTypes.getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)CoreMatchers.is((Object)Apple.class.getName()));
    }

    @Test
    public void getProperties() {
        Set fields = IntrospectionUtils.getFieldsWithGetters(SomePojo.class, (ReflectionCache)this.reflectionCache);
        Type somePojo = this.typeSupplier.apply(SomePojo.class);
        List fieldsWithGetters = IntrospectionUtils.getFieldsWithGetters((Type)somePojo);
        Assert.assertThat((Object)fieldsWithGetters.size(), (Matcher)CoreMatchers.is((Object)fields.size()));
    }

    @Test
    public void listWithNoGenerics() throws Exception {
        MetadataType returnType = IntrospectionUtils.getMethodReturnType((MethodElement)this.getMethod("listNoGenerics", new Class[0]));
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.instanceOf(ArrayType.class));
        Assert.assertThat((Object)((ArrayType)returnType).getType(), (Matcher)CoreMatchers.instanceOf(ObjectType.class));
    }

    @Test
    public void mapWithNoGenerics() throws Exception {
        MetadataType returnType = IntrospectionUtils.getMethodReturnType((MethodElement)this.getMethod("mapNoGenerics", new Class[0]));
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.instanceOf(ObjectType.class));
        Assert.assertThat(((ObjectType)returnType).getOpenRestriction().get(), (Matcher)CoreMatchers.instanceOf(AnyType.class));
    }

    private void assertField(String name, MetadataType metadataType, Collection<Field> fields) {
        Field field = this.findField(name, fields);
        Assert.assertThat((Object)field, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)field.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat(field.getType(), (Matcher)CoreMatchers.equalTo((Object)JavaTypeUtils.getType((MetadataType)metadataType)));
    }

    private Field findField(String name, Collection<Field> fields) {
        return (Field)CollectionUtils.find(fields, f -> name.equals(((Field)f).getName()));
    }

    private void assertType(MetadataType type, Class<?> rawType) {
        Assert.assertThat((Object)rawType.isAssignableFrom(JavaTypeUtils.getType((MetadataType)type)), (Matcher)CoreMatchers.is((Object)true));
    }

    private OperationElement getMethod(String methodName, Class<?> ... parameterTypes) throws Exception {
        return this.operationSupplier.apply(methodName, parameterTypes);
    }

    private void assertDictionary(MetadataType metadataType, Class<?> valueType) {
        Assert.assertThat((Object)metadataType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
        ObjectType dictionaryType = (ObjectType)metadataType;
        this.assertType((MetadataType)dictionaryType, Map.class);
        Assert.assertThat((Object)dictionaryType.getOpenRestriction().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.assertType((MetadataType)dictionaryType.getOpenRestriction().get(), valueType);
    }

    private void assertList(MetadataType metadataType, Class<?> listItemType) {
        Assert.assertThat((Object)metadataType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        this.assertType(metadataType, List.class);
        MetadataType itemMetadataType = ((ArrayType)metadataType).getType();
        this.assertType(itemMetadataType, listItemType);
    }

    public Map<String, Apple> foo() {
        return new HashMap<String, Apple>();
    }

    public List listNoGenerics() {
        return new ArrayList();
    }

    public Map mapNoGenerics() {
        return new LinkedHashMap();
    }

    public Result<String, Object> operationResult() {
        return null;
    }

    public Result resultWithNoGenerics() {
        return null;
    }

    public Result<?, ?> resultWithWildcardGenerics() {
        return null;
    }

    public PagingProvider<Object, String> pagingProvider() {
        return null;
    }

    public PagingProvider<Object, Result<String, Object>> pagingProviderOperationResult() {
        return null;
    }

    public int bar(String s, Long l, Apple apple, Map<Banana, Kiwi> fruits) {
        return Objects.hash(s, l, apple, fruits);
    }

    public TestPagingProvider getPagingProvider() {
        return null;
    }

    public List<FruitBasket> getBaskets() {
        return this.baskets;
    }

    public void setBaskets(List<FruitBasket> baskets) {
        this.baskets = baskets;
    }

    private void assertAttributesType(String method) throws Exception {
        MetadataType attributesType = IntrospectionUtils.getMethodReturnAttributesType((MethodElement)this.getMethod(method, new Class[0]));
        Assert.assertThat((Object)attributesType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
        this.assertType(attributesType, Object.class);
    }

    private void assertVoidAttributesType(String method) throws Exception {
        MetadataType attributesType = IntrospectionUtils.getMethodReturnAttributesType((MethodElement)this.getMethod(method, new Class[0]));
        Assert.assertThat((Object)attributesType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(VoidType.class)));
    }

    private void assertReturnType(String method) throws Exception {
        MetadataType returnType = IntrospectionUtils.getMethodReturnType((MethodElement)this.getMethod(method, new Class[0]));
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)));
        this.assertType(returnType, String.class);
    }

    private void assertPagingProviderReturnType(String method) throws Exception {
        MetadataType returnType = IntrospectionUtils.getMethodReturnType((MethodElement)this.getMethod(method, new Class[0]));
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        Assert.assertThat((Object)((ArrayType)returnType).getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)));
        this.assertType(((ArrayType)returnType).getType(), String.class);
    }

    private void assertPagingProviderReturnResultType(String method) throws Exception {
        MetadataType returnType = IntrospectionUtils.getMethodReturnType((MethodElement)this.getMethod(method, new Class[0]));
        Assert.assertThat((Object)returnType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayType.class)));
        ExtensionsTestUtils.assertMessageType(((ArrayType)returnType).getType(), CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StringType.class)), CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
    }

    private static class ClassOperationSupplier
    implements BiFunction<String, Class[], OperationElement> {
        private ClassOperationSupplier() {
        }

        @Override
        public OperationElement apply(String methodName, Class[] paramTypes) {
            try {
                return new OperationWrapper(IntrospectionUtilsTestCase.class.getMethod(methodName, paramTypes), ExtensionsTestUtils.TYPE_LOADER);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException();
            }
        }
    }

    private class TestPagingProvider
    implements PagingProvider<Object, Result<Banana, Apple>> {
        private TestPagingProvider() {
        }

        public List<Result<Banana, Apple>> getPage(Object connection) {
            return null;
        }

        public Optional<Integer> getTotalResults(Object connection) {
            return null;
        }

        public void close(Object connection) throws MuleException {
        }
    }

    public static class SomePojo {
        private String aString;
        private Integer someNumber;
        private String nonProperty;

        public String getaString() {
            return this.aString;
        }

        public void setaString(String aString) {
            this.aString = aString;
        }

        public Integer getSomeNumber() {
            return this.someNumber;
        }

        public void setSomeNumber(Integer someNumber) {
            this.someNumber = someNumber;
        }
    }
}

