/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.tooling;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.module.extension.api.tooling.ExtensionConnectivityTestingStrategy;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class ExtensionConnectivityTestingStrategyTestCase
extends AbstractMuleTestCase {
    private ExtensionConnectivityTestingStrategy extensionConnectivityTestingStrategy;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConnectionProviderResolver connectionProviderResolver;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConnectionProvider connectionProvider;
    private ConnectionManager connectionManager;

    public ExtensionConnectivityTestingStrategyTestCase() {
        this.connectionManager = new DefaultConnectionManager(this.muleContext);
    }

    @Before
    public void createTestingInstance() {
        this.extensionConnectivityTestingStrategy = new ExtensionConnectivityTestingStrategy(this.connectionManager, this.muleContext);
    }

    @Test
    public void connectionProviderInConfigWithInvalidConnection() throws MuleException {
        ConnectionValidationResult connectionResult = this.testConnectivityWithConnectionProvider(false);
        Assert.assertThat((Object)connectionResult.isValid(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void connectionProviderInConfigWithValidConnection() throws MuleException {
        ConnectionValidationResult connectionResult = this.testConnectivityWithConnectionProvider(true);
        Assert.assertThat((Object)connectionResult.isValid(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void connectionProviderThrowsException() throws MuleException {
        RuntimeException e = new RuntimeException();
        Mockito.when((Object)this.connectionProviderResolver.resolve((ValueResolvingContext)Matchers.any())).thenThrow(new Throwable[]{e});
        ConnectionValidationResult connectionResult = this.extensionConnectivityTestingStrategy.testConnectivity((Object)this.connectionProviderResolver);
        Assert.assertThat((Object)connectionResult.isValid(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)connectionResult.getException(), (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)e)));
    }

    private ConnectionValidationResult testConnectivityWithConnectionProvider(boolean isValidConnection) throws MuleException {
        Mockito.when((Object)this.connectionProviderResolver.resolve((ValueResolvingContext)Matchers.any())).thenReturn((Object)new Pair((Object)this.connectionProvider, Mockito.mock(ResolverSetResult.class)));
        ConnectionValidationResult validationResult = isValidConnection ? ConnectionValidationResult.success() : ConnectionValidationResult.failure((String)"", null);
        Mockito.when((Object)this.connectionProvider.validate(Matchers.any())).thenReturn((Object)validationResult);
        ConnectionValidationResult connectionResult = this.extensionConnectivityTestingStrategy.testConnectivity((Object)this.connectionProviderResolver);
        return connectionResult;
    }
}

