/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.DynamicMetadataDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.EnricherTestUtils;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.message.StringAttributes;
import org.mule.test.metadata.extension.MetadataExtension;
import org.mule.test.metadata.extension.model.attribute.AbstractOutputAttributes;
import org.mule.test.metadata.extension.model.shapes.Shape;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class DynamicMetadataDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    private static final String CONTENT_METADATA_WITH_KEY_ID = "contentMetadataWithKeyId";
    private ExtensionDeclaration declaration;

    @Before
    public void setUp() {
        DefaultJavaModelLoaderDelegate loader = new DefaultJavaModelLoaderDelegate(MetadataExtension.class, MuleManifest.getProductVersion());
        ExtensionDeclarer declarer = loader.declare((ExtensionLoadingContext)new DefaultExtensionLoadingContext(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        new DynamicMetadataDeclarationEnricher().enrich((ExtensionLoadingContext)new DefaultExtensionLoadingContext(declarer, ((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        this.declaration = (ExtensionDeclaration)declarer.getDeclaration();
    }

    @Test
    public void parseMetadataAnnotationsOnParameter() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getDeclaration(((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getOperations(), CONTENT_METADATA_WITH_KEY_ID);
        List parameters = operationDeclaration.getAllParameters();
        this.assertParameterIsMetadataKeyPart((ParameterDeclaration)EnricherTestUtils.getDeclaration(parameters, "type"));
        this.assertParameterIsMetadataContent((ParameterDeclaration)EnricherTestUtils.getDeclaration(parameters, "content"));
    }

    @Test
    public void declareStaticAndDynamicTypesInOperation() {
        List operations = ((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getOperations();
        OperationDeclaration dynamicContent = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, CONTENT_METADATA_WITH_KEY_ID);
        this.assertOutputType(dynamicContent.getOutput(), ExtensionsTestUtils.toMetadataType(Object.class), true);
        this.assertOutputType(dynamicContent.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(Void.TYPE), false);
        List params = dynamicContent.getAllParameters();
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "type"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "content"), ExtensionsTestUtils.toMetadataType(Object.class));
        OperationDeclaration dynamicOutput = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "outputMetadataWithKeyId");
        this.assertOutputType(dynamicOutput.getOutput(), ExtensionsTestUtils.toMetadataType(Object.class), true);
        this.assertOutputType(dynamicOutput.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(Void.TYPE), false);
        params = dynamicOutput.getAllParameters();
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "type"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "content"), ExtensionsTestUtils.toMetadataType(Object.class));
        OperationDeclaration dynaimcContentAndOutput = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "contentAndOutputMetadataWithKeyId");
        this.assertOutputType(dynaimcContentAndOutput.getOutput(), ExtensionsTestUtils.toMetadataType(Object.class), true);
        this.assertOutputType(dynaimcContentAndOutput.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(Void.TYPE), false);
        params = dynaimcContentAndOutput.getAllParameters();
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "type"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "content"), ExtensionsTestUtils.toMetadataType(Object.class));
        operations = this.declaration.getOperations();
        OperationDeclaration dynamicOutputAndAttributes = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "outputAttributesWithDynamicMetadata");
        this.assertOutputType(dynamicOutputAndAttributes.getOutput(), ExtensionsTestUtils.toMetadataType(Object.class), true);
        this.assertOutputType(dynamicOutputAndAttributes.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(AbstractOutputAttributes.class), true);
        params = dynamicOutputAndAttributes.getAllParameters();
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(params, "type"), ExtensionsTestUtils.toMetadataType(String.class));
        OperationDeclaration staticOutputOnly = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "typeWithDeclaredSubtypesMetadata");
        this.assertOutputType(staticOutputOnly.getOutput(), ExtensionsTestUtils.toMetadataType(Boolean.TYPE), false);
        this.assertOutputType(staticOutputOnly.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(Void.TYPE), false);
        OperationDeclaration staticOutputAndAttributes = (OperationDeclaration)EnricherTestUtils.getDeclaration(operations, "outputAttributesWithDeclaredSubtypesMetadata");
        this.assertOutputType(staticOutputAndAttributes.getOutput(), ExtensionsTestUtils.toMetadataType(Shape.class), false);
        this.assertOutputType(staticOutputAndAttributes.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(AbstractOutputAttributes.class), false);
    }

    @Test
    public void declareStaticAndDynamicTypesInSource() {
        List messageSources = ((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getMessageSources();
        SourceDeclaration sourceDynamicAttributes = (SourceDeclaration)EnricherTestUtils.getDeclaration(messageSources, "MetadataSource");
        this.assertOutputType(sourceDynamicAttributes.getOutput(), (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, Object.class))).openWith(ExtensionsTestUtils.TYPE_LOADER.load(Object.class)).build(), true);
        this.assertOutputType(sourceDynamicAttributes.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(StringAttributes.class), false);
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(sourceDynamicAttributes.getAllParameters(), "type"), ExtensionsTestUtils.toMetadataType(String.class));
        messageSources = this.declaration.getMessageSources();
        SourceDeclaration sourceStaticAttributes = (SourceDeclaration)EnricherTestUtils.getDeclaration(messageSources, "MetadataSourceWithMultilevel");
        this.assertOutputType(sourceStaticAttributes.getOutput(), (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, Object.class))).openWith(ExtensionsTestUtils.TYPE_LOADER.load(Object.class)).build(), true);
        this.assertOutputType(sourceStaticAttributes.getOutputAttributes(), ExtensionsTestUtils.toMetadataType(StringAttributes.class), false);
        List locationKey = sourceStaticAttributes.getAllParameters();
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(locationKey, "continent"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(locationKey, "country"), ExtensionsTestUtils.toMetadataType(String.class));
        this.assertParameterType((ParameterDeclaration)EnricherTestUtils.getDeclaration(locationKey, "city"), ExtensionsTestUtils.toMetadataType(String.class));
    }

    private void assertParameterIsMetadataKeyPart(ParameterDeclaration param) {
        EnricherTestUtils.checkIsPresent((BaseDeclaration)param, MetadataKeyPartModelProperty.class);
    }

    private void assertParameterIsMetadataContent(ParameterDeclaration param) {
        MatcherAssert.assertThat((Object)param.getRole(), (Matcher)CoreMatchers.is((Object)ParameterRole.CONTENT));
    }

    private void assertParameterType(ParameterDeclaration param, MetadataType type) {
        MatcherAssert.assertThat((Object)param.getType(), (Matcher)CoreMatchers.equalTo((Object)type));
    }

    private void assertOutputType(OutputDeclaration output, MetadataType type, boolean isDynamic) {
        MatcherAssert.assertThat((Object)output.getType(), (Matcher)CoreMatchers.equalTo((Object)type));
        MatcherAssert.assertThat((Object)output.hasDynamicType(), (Matcher)CoreMatchers.is((Object)isDynamic));
    }
}

