/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.objectbuilder;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilderUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class DefaultObjectBuilder<T>
implements ObjectBuilder<T>,
Initialisable,
ParameterValueResolver {
    private static final ValueResolvingContext RESOLVING_CONTEXT = ValueResolvingContext.from(org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent());
    protected final Class<T> prototypeClass;
    protected final Map<FieldSetter, ValueResolver<Object>> resolvers = new HashMap<FieldSetter, ValueResolver<Object>>();
    protected final Map<String, ValueResolver<? extends Object>> resolverByFieldName = new HashMap<String, ValueResolver<? extends Object>>();
    protected ReflectionCache reflectionCache;
    private String name = null;
    private String encoding = null;
    @Inject
    private MuleContext muleContext;

    public DefaultObjectBuilder(Class<T> prototypeClass, ReflectionCache reflectionCache) {
        Preconditions.checkState((reflectionCache != null ? 1 : 0) != 0, (String)"null reflection cache");
        IntrospectionUtils.checkInstantiable(prototypeClass, reflectionCache);
        this.prototypeClass = prototypeClass;
        this.reflectionCache = reflectionCache;
    }

    public ObjectBuilder<T> addPropertyResolver(String propertyName, ValueResolver<? extends Object> resolver) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)propertyName) ? 1 : 0) != 0, (String)"property name cannot be blank");
        Field field = IntrospectionUtils.getField(this.prototypeClass, propertyName, this.reflectionCache).orElseThrow(() -> new IllegalArgumentException(String.format("Class '%s' does not contain property '%s'", this.prototypeClass.getName(), propertyName)));
        return this.addPropertyResolver(field, resolver);
    }

    public ObjectBuilder<T> addPropertyResolver(Field field, ValueResolver<? extends Object> resolver) {
        Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"resolver cannot be null");
        this.resolverByFieldName.put(field.getName(), resolver);
        this.resolvers.put(new FieldSetter(field), resolver);
        return this;
    }

    @Override
    public boolean isDynamic() {
        return MuleExtensionUtils.hasAnyDynamic(this.resolvers.values());
    }

    @Override
    public T build(ValueResolvingContext context) throws MuleException {
        T object = ObjectBuilderUtils.createInstance(this.prototypeClass);
        for (Map.Entry<FieldSetter, ValueResolver<Object>> entry : this.resolvers.entrySet()) {
            entry.getKey().set(object, context == null || context.resolveCursors() ? ResolverUtils.resolveCursor(ResolverUtils.resolveValue(entry.getValue(), context)) : ResolverUtils.resolveValue(entry.getValue(), context));
        }
        IntrospectionUtils.injectFields(object, this.name, this.encoding, this.reflectionCache);
        return object;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.resolvers.values(), (MuleContext)this.muleContext);
    }

    @Override
    public Object getParameterValue(String parameterName) throws ValueResolvingException {
        ValueResolver<? extends Object> valueResolver = this.resolverByFieldName.get(parameterName);
        if (valueResolver == null) {
            return null;
        }
        try {
            return valueResolver.resolve(RESOLVING_CONTEXT);
        }
        catch (Exception e) {
            throw new ValueResolvingException(String.format("An error occurred trying to resolve value for parameter [%s]", parameterName), e);
        }
    }
}

