/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.Optional;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.ByteStreamingManager;
import org.mule.runtime.core.api.streaming.object.ObjectStreamingManager;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.api.loader.java.property.ComponentExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.InterceptorsModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.mule.runtime.module.extension.internal.runtime.operation.ComponentMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ComponentMessageProcessorTestCase
extends AbstractMuleContextTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentMessageProcessorTestCase.class);
    private ComponentMessageProcessor<ComponentModel> processor;
    private ExtensionModel extensionModel;
    private ComponentModel componentModel;
    private ResolverSet resolverSet;
    private ExtensionManager extensionManager;
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Before
    public void before() throws MuleException {
        CoreEvent response = this.testEvent();
        this.extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("mock").build());
        Mockito.when((Object)this.extensionModel.getModelProperty(ClassLoaderModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.extensionModel.getModelProperty(ExceptionHandlerModelProperty.class)).thenReturn(Optional.empty());
        this.componentModel = (ComponentModel)Mockito.mock(ComponentModel.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{EnrichableModel.class}));
        Mockito.when((Object)this.componentModel.getModelProperty(ComponentExecutorModelProperty.class)).thenReturn(Optional.of(new ComponentExecutorModelProperty((cp, params) -> ctx -> Mono.just((Object)response))));
        Mockito.when((Object)this.componentModel.getModelProperty(MetadataResolverFactoryModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentModel.getModelProperty(PagedOperationModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentModel.getModelProperty(MediaTypeModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentModel.getModelProperty(InterceptorsModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentModel.getModelProperty(ExceptionHandlerModelProperty.class)).thenReturn(Optional.empty());
        this.resolverSet = (ResolverSet)Mockito.mock(ResolverSet.class);
        this.extensionManager = (ExtensionManager)Mockito.mock(ExtensionManager.class);
        Mockito.when((Object)this.extensionManager.getConfigurationProvider(this.extensionModel, this.componentModel)).thenReturn(Optional.empty());
        this.processor = new ComponentMessageProcessor<ComponentModel>(this.extensionModel, this.componentModel, null, null, null, this.resolverSet, null, null, this.extensionManager, null, null){

            protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
            }

            public ReactiveProcessor.ProcessingType getProcessingType() {
                return ReactiveProcessor.ProcessingType.CPU_LITE;
            }
        };
        this.processor.setCacheIdGeneratorFactory((MetadataCacheIdGeneratorFactory)Mockito.mock(MetadataCacheIdGeneratorFactory.class));
        StreamingManager streamingManager = (StreamingManager)Mockito.mock(StreamingManager.class);
        Mockito.when((Object)streamingManager.forObjects()).thenReturn(Mockito.mock(ObjectStreamingManager.class));
        Mockito.when((Object)streamingManager.forBytes()).thenReturn(Mockito.mock(ByteStreamingManager.class));
        this.processor.setStreamingManager(streamingManager);
        LifecycleUtils.initialiseIfNeeded(this.processor, (MuleContext)muleContext);
    }

    @After
    public void after() {
        LifecycleUtils.disposeIfNeeded(this.processor, (Logger)LOGGER);
    }

    @Test
    public void happyPath() throws MuleException {
        ResolverSetResult resolverSetResult = (ResolverSetResult)Mockito.mock(ResolverSetResult.class);
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)Mockito.any(ValueResolvingContext.class))).thenReturn((Object)resolverSetResult);
        Assert.assertNotNull((Object)Mono.from((Publisher)this.processor.apply((Publisher)Mono.just((Object)this.testEvent()))).block());
    }

    @Test
    public void muleRuntimeExceptionInResolutionResult() throws MuleException {
        ExpressionRuntimeException thrown = new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage((String)"Expected"));
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)Mockito.any(ValueResolvingContext.class))).thenThrow(new Throwable[]{thrown});
        this.expected.expect(Matchers.sameInstance((Object)thrown));
        Mono.from((Publisher)this.processor.apply((Publisher)Mono.just((Object)this.testEvent()))).block();
    }

    @Test
    public void muleExceptionInResolutionResult() throws MuleException {
        DefaultMuleException thrown = new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)"Expected"));
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)Mockito.any(ValueResolvingContext.class))).thenThrow(new Throwable[]{thrown});
        this.expected.expectCause(Matchers.sameInstance((Object)thrown));
        Mono.from((Publisher)this.processor.apply((Publisher)Mono.just((Object)this.testEvent()))).block();
    }

    @Test
    public void runtimeExceptionInResolutionResult() throws MuleException {
        NullPointerException thrown = new NullPointerException("Expected");
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)Mockito.any(ValueResolvingContext.class))).thenThrow(new Throwable[]{thrown});
        this.expected.expect(Matchers.sameInstance((Object)thrown));
        Mono.from((Publisher)this.processor.apply((Publisher)Mono.just((Object)this.testEvent()))).block();
    }
}

