/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.streaming.PagingProviderProducer;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class PagingProviderProducerTestCase {
    private ExtensionConnectionSupplier extensionConnectionSupplier = (ExtensionConnectionSupplier)Mockito.mock(ExtensionConnectionSupplier.class);
    private ExecutionContextAdapter executionContext = (ExecutionContextAdapter)Mockito.mock(ExecutionContextAdapter.class);
    private PagingProvider<Object, String> delegate = (PagingProvider)Mockito.mock(PagingProvider.class);
    private ConfigurationInstance config = (ConfigurationInstance)Mockito.mock(ConfigurationInstance.class);
    @InjectMocks
    private PagingProviderProducer<String> producer = this.createProducer();

    private PagingProviderProducer<String> createProducer() {
        return new PagingProviderProducer(this.delegate, this.config, this.executionContext, this.extensionConnectionSupplier);
    }

    @Before
    public void setUp() throws MuleException {
        Mockito.when((Object)this.config.getValue()).thenReturn((Object)"config");
        ConnectionHandler handler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Mockito.when((Object)handler.getConnection()).thenReturn(new Object());
        Mockito.when((Object)this.extensionConnectionSupplier.getConnection(this.executionContext)).thenReturn((Object)handler);
        ExtensionModel extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.executionContext.getExtensionModel()).thenReturn((Object)extensionModel);
        Mockito.when((Object)extensionModel.getModelProperty((Class)org.mockito.Matchers.any())).thenReturn(Optional.empty());
    }

    @Test
    public void produce() throws Exception {
        List<String> page = Arrays.asList("bleh");
        Mockito.when((Object)this.delegate.getPage(org.mockito.Matchers.anyObject())).thenReturn(page);
        MatcherAssert.assertThat(page, (Matcher)Matchers.sameInstance((Object)this.producer.produce()));
    }

    @Test
    public void produceWithDifferentConnections() throws Exception {
        ConnectionHandler connectionHandler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Mockito.when((Object)this.extensionConnectionSupplier.getConnection((ExecutionContextAdapter)org.mockito.Matchers.any())).thenReturn((Object)connectionHandler);
        this.produce();
        this.produce();
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.times((int)2))).getConnection();
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.times((int)2))).release();
    }

    @Test
    public void produceWithStickyConnection() throws Exception {
        Mockito.when((Object)this.delegate.useStickyConnections()).thenReturn((Object)true);
        this.producer = this.createProducer();
        ConnectionHandler connectionHandler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Mockito.when((Object)this.extensionConnectionSupplier.getConnection((ExecutionContextAdapter)org.mockito.Matchers.any())).thenReturn((Object)connectionHandler);
        this.produce();
        this.produce();
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.times((int)1))).getConnection();
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.never())).release();
        this.producer.close();
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler)).release();
    }

    @Test
    public void totalAvailable() {
        int total = 10;
        Mockito.when((Object)this.delegate.getTotalResults(org.mockito.Matchers.anyObject())).thenReturn(Optional.of(10));
        MatcherAssert.assertThat((Object)10, (Matcher)Matchers.is((Object)this.producer.getSize()));
    }

    @Test
    public void closeQuietly() throws Exception {
        ConnectionHandler connectionHandler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Mockito.when((Object)this.extensionConnectionSupplier.getConnection((ExecutionContextAdapter)org.mockito.Matchers.any())).thenReturn((Object)connectionHandler);
        this.producer.close();
        ((PagingProvider)Mockito.verify(this.delegate)).close(org.mockito.Matchers.any());
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler, (VerificationMode)Mockito.times((int)1))).release();
    }

    @Test(expected=Exception.class)
    public void closeNoisely() throws Exception {
        ((PagingProvider)Mockito.doThrow((Throwable)new DefaultMuleException((Throwable)new Exception())).when(this.delegate)).close(org.mockito.Matchers.any());
        this.producer.close();
    }
}

