/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.connection.ErrorTypeHandlerConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.PoolingConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.ReconnectableConnectionProviderWrapper;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.module.extension.internal.runtime.config.ClassLoaderConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.config.ConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class DefaultConnectionProviderObjectBuilder<C>
extends ConnectionProviderObjectBuilder<C> {
    DefaultConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, ExtensionModel extensionModel, MuleContext muleContext) {
        super(providerModel, resolverSet, extensionModel, muleContext);
    }

    public DefaultConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, ExtensionModel extensionModel, MuleContext muleContext) {
        super(providerModel, resolverSet, poolingProfile, reconnectionConfig, extensionModel, muleContext);
    }

    @Override
    public final Pair<ConnectionProvider<C>, ResolverSetResult> build(ResolverSetResult result) throws MuleException {
        ConnectionProvider<C> provider = this.doBuild(result);
        this.muleContext.getInjector().inject(provider);
        provider = this.applyConnectionProviderClassLoaderProxy(provider);
        provider = this.applyConnectionManagement(provider);
        provider = this.applyErrorHandling(provider);
        return new Pair(provider, (Object)result);
    }

    protected ConnectionProvider<C> doBuild(ResolverSetResult result) throws MuleException {
        ConnectionProvider provider = (ConnectionProvider)super.build(result).getFirst();
        IntrospectionUtils.injectFields((EnrichableModel)this.providerModel, provider, this.ownerConfigName, this.muleContext.getConfiguration().getDefaultEncoding());
        return provider;
    }

    private ConnectionProvider<C> applyErrorHandling(ConnectionProvider<C> provider) {
        return new ErrorTypeHandlerConnectionProviderWrapper(provider, this.extensionModel, this.reconnectionConfig, this.muleContext);
    }

    private ConnectionProvider<C> applyConnectionManagement(ConnectionProvider<C> provider) {
        ConnectionManagementType connectionManagementType = this.providerModel.getConnectionManagementType();
        provider = connectionManagementType == ConnectionManagementType.POOLING ? new PoolingConnectionProviderWrapper((ConnectionProvider)provider, this.poolingProfile, this.reconnectionConfig) : new ReconnectableConnectionProviderWrapper(provider, this.reconnectionConfig);
        return provider;
    }

    private ConnectionProvider<C> applyConnectionProviderClassLoaderProxy(ConnectionProvider provider) {
        ClassLoader extensionClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader appRegionClassLoader = this.muleContext.getExecutionClassLoader().getParent();
        return ClassLoaderConnectionProviderWrapper.newInstance(provider, (ClassLoader)new CompositeClassLoader(extensionClassLoader, new ClassLoader[]{appRegionClassLoader}));
    }
}

