/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.time.Time;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.core.internal.util.version.JdkVersionUtils;
import org.mule.runtime.extension.api.property.ImplicitConfigNameModelProperty;
import org.mule.runtime.extension.api.property.ManyImplicitConfigsModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.manager.ConfigurationExpirationMonitor;
import org.mule.runtime.module.extension.internal.manager.DefaultConfigurationExpirationMonitor;
import org.mule.runtime.module.extension.internal.manager.ExtensionActivator;
import org.mule.runtime.module.extension.internal.manager.ExtensionRegistry;
import org.mule.runtime.module.extension.internal.manager.NoConfigRefFoundException;
import org.mule.runtime.module.extension.internal.manager.jdk.ExtensionJdkValidator;
import org.mule.runtime.module.extension.internal.manager.jdk.LooseExtensionJdkValidator;
import org.mule.runtime.module.extension.internal.manager.jdk.NullExtensionJdkValidator;
import org.mule.runtime.module.extension.internal.manager.jdk.StrictExtensionJdkValidator;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultImplicitConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ImplicitConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExtensionManager
implements ExtensionManager,
Initialisable,
Startable,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionManager.class);
    static final String EXTENSION_JVM_ENFORCEMENT_PROPERTY = "mule.jvm.version.extension.enforcement";
    static final String JVM_ENFORCEMENT_STRICT = "STRICT";
    static final String JVM_ENFORCEMENT_LOOSE = "LOOSE";
    static final String JVM_ENFORCEMENT_DISABLED = "DISABLED";
    private final ImplicitConfigurationProviderFactory implicitConfigurationProviderFactory = new DefaultImplicitConfigurationProviderFactory();
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    @Inject
    private ReflectionCache reflectionCache;
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    @Inject
    private MuleContext muleContext;
    private ExtensionRegistry extensionRegistry;
    private ConfigurationExpirationMonitor configurationExpirationMonitor;
    private ExtensionActivator extensionActivator;
    private ExtensionJdkValidator extensionJdkValidator;

    public void initialise() throws InitialisationException {
        if (this.initialised.compareAndSet(false, true)) {
            this.extensionRegistry = new ExtensionRegistry((Registry)new DefaultRegistry(this.muleContext));
            this.extensionActivator = new ExtensionActivator(this.muleContext);
            LifecycleUtils.initialiseIfNeeded((Object)this.implicitConfigurationProviderFactory, (MuleContext)this.muleContext);
            this.resolveJdkValidator();
        }
    }

    public void start() throws MuleException {
        this.configurationExpirationMonitor = this.newConfigurationExpirationMonitor();
        this.configurationExpirationMonitor.beginMonitoring();
        this.extensionActivator.start();
    }

    public void stop() throws MuleException {
        this.extensionActivator.stop();
        this.configurationExpirationMonitor.stopMonitoring();
    }

    public void registerExtension(ExtensionModel extensionModel) {
        String extensionName = extensionModel.getName();
        String extensionVersion = extensionModel.getVersion();
        String extensionVendor = extensionModel.getVendor();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registering extension {} (version: {} vendor: {} )", new Object[]{extensionName, extensionVersion, extensionVendor});
        }
        this.extensionJdkValidator.validateJdkSupport(extensionModel);
        if (this.extensionRegistry.containsExtension(extensionName)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("An extension of name '{}' (version: {} vendor {}) is already registered. Skipping...", new Object[]{extensionName, extensionVersion, extensionVendor});
            }
        } else {
            ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(extensionModel), () -> {
                this.extensionRegistry.registerExtension(extensionName, extensionModel);
                this.extensionActivator.activateExtension(extensionModel);
            });
        }
    }

    public void registerConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.extensionRegistry.registerConfigurationProvider(configurationProvider, this.muleContext);
    }

    public void unregisterConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.extensionRegistry.unregisterConfigurationProvider(configurationProvider, this.muleContext);
    }

    public ConfigurationInstance getConfiguration(String configurationProviderName, CoreEvent muleEvent) {
        return this.getConfigurationProvider(configurationProviderName).map(provider -> provider.get((Event)muleEvent)).orElseThrow(() -> new IllegalArgumentException(String.format("There is no registered configurationProvider under name '%s'", configurationProviderName)));
    }

    public Optional<ConfigurationInstance> getConfiguration(ExtensionModel extensionModel, ComponentModel componentModel, CoreEvent muleEvent) {
        return this.getConfigurationProvider(extensionModel, componentModel, muleEvent).map(p -> p.get((Event)muleEvent));
    }

    public Optional<ConfigurationProvider> getConfigurationProvider(ExtensionModel extensionModel, ComponentModel componentModel, CoreEvent muleEvent) {
        Optional<ConfigurationProvider> configurationProvider = this.getConfigurationProvider(extensionModel, componentModel);
        if (configurationProvider.isPresent()) {
            return configurationProvider;
        }
        Optional<ConfigurationProvider> configurationModel = componentModel.getModelProperty(ImplicitConfigNameModelProperty.class).flatMap(mp -> extensionModel.getConfigurationModel(mp.getImplicitConfigName()));
        return configurationModel.map(c -> this.createImplicitConfiguration(extensionModel, (ConfigurationModel)c, muleEvent));
    }

    public Optional<ConfigurationProvider> getConfigurationProvider(ExtensionModel extensionModel, ComponentModel componentModel) {
        if (componentModel.getModelProperty(ManyImplicitConfigsModelProperty.class).isPresent()) {
            throw new IllegalStateException(String.format("No configuration can be inferred for extension '%s'", extensionModel.getName()));
        }
        Optional extensionConfigurationModel = componentModel.getModelProperty(ImplicitConfigNameModelProperty.class).flatMap(mp -> extensionModel.getConfigurationModel(mp.getImplicitConfigName()));
        if (!extensionConfigurationModel.isPresent() && ExtensionModelUtils.requiresConfig((ExtensionModel)extensionModel, (NamedObject)componentModel)) {
            throw new NoConfigRefFoundException(extensionModel, componentModel);
        }
        return extensionConfigurationModel.flatMap(c -> this.getConfigurationProvider(MuleExtensionUtils.getImplicitConfigurationProviderName(extensionModel, c, this.muleContext.getArtifactType(), this.muleContext.getId(), this.featureFlaggingService)));
    }

    public Optional<ConfigurationProvider> getConfigurationProvider(String configurationProviderName) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)configurationProviderName) ? 1 : 0) != 0, (String)"cannot get configuration from a blank provider name");
        return this.extensionRegistry.getConfigurationProvider(configurationProviderName);
    }

    private ConfigurationProvider createImplicitConfiguration(ExtensionModel extensionModel, ConfigurationModel configurationModel, CoreEvent muleEvent) {
        String implicitConfigurationProviderName = MuleExtensionUtils.getImplicitConfigurationProviderName(extensionModel, configurationModel, this.muleContext.getArtifactType(), this.muleContext.getId(), this.featureFlaggingService);
        return this.extensionRegistry.getConfigurationProvider(implicitConfigurationProviderName).orElseGet(() -> {
            ExtensionModel extensionModel2 = extensionModel;
            synchronized (extensionModel2) {
                return this.extensionRegistry.getConfigurationProvider(implicitConfigurationProviderName).orElseGet(() -> {
                    ConfigurationProvider implicitConfigurationProvider = this.implicitConfigurationProviderFactory.createImplicitConfigurationProvider(extensionModel, configurationModel, muleEvent, this.getReflectionCache(), this.expressionManager);
                    this.registerConfigurationProvider(implicitConfigurationProvider);
                    return implicitConfigurationProvider;
                });
            }
        });
    }

    private Optional<ConfigurationModel> selectImplicitConfigurationModel(ExtensionModel extensionModel, Set<ConfigurationModel> assignableConfigurationModels) {
        List implicitConfigurationModels = assignableConfigurationModels.stream().filter(ExtensionModelUtils::canBeUsedImplicitly).collect(Collectors.toList());
        if (implicitConfigurationModels.isEmpty()) {
            return Optional.empty();
        }
        if (implicitConfigurationModels.size() == 1) {
            return Optional.ofNullable((ConfigurationModel)implicitConfigurationModels.get(0));
        }
        throw new IllegalStateException(String.format("No configuration can be inferred for extension '%s'", extensionModel.getName()));
    }

    public Set<ExtensionModel> getExtensions() {
        return this.extensionRegistry.getExtensions();
    }

    public Optional<ExtensionModel> getExtension(String extensionName) {
        return this.extensionRegistry.getExtension(extensionName);
    }

    private ConfigurationExpirationMonitor newConfigurationExpirationMonitor() {
        Time freq = this.getConfigurationExpirationFrequency();
        return DefaultConfigurationExpirationMonitor.Builder.newBuilder(this.extensionRegistry, this.muleContext).runEvery(freq.getTime(), freq.getUnit()).onExpired((key, object) -> this.disposeConfiguration((String)key, (ConfigurationInstance)object)).build();
    }

    public void disposeConfiguration(String key, ConfigurationInstance configuration) {
        try {
            LifecycleUtils.stopIfNeeded((Object)configuration);
            LifecycleUtils.disposeIfNeeded((Object)configuration, (Logger)LOGGER);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Could not dispose expired dynamic config of key '%s' and type %s", key, configuration.getClass().getName()), (Throwable)e);
        }
    }

    private Time getConfigurationExpirationFrequency() {
        return this.muleContext.getConfiguration().getDynamicConfigExpiration().getFrequency();
    }

    void resolveJdkValidator() {
        JdkVersionUtils.JdkVersion runningJdkVersion = JdkVersionUtils.getJdkVersion();
        String enforcementMode = System.getProperty(EXTENSION_JVM_ENFORCEMENT_PROPERTY, JVM_ENFORCEMENT_STRICT);
        if (JVM_ENFORCEMENT_STRICT.equals(enforcementMode)) {
            this.extensionJdkValidator = new StrictExtensionJdkValidator(runningJdkVersion);
        } else if (JVM_ENFORCEMENT_LOOSE.equals(enforcementMode)) {
            this.extensionJdkValidator = new LooseExtensionJdkValidator(runningJdkVersion, LOGGER);
        } else if (JVM_ENFORCEMENT_DISABLED.equals(enforcementMode)) {
            this.extensionJdkValidator = new NullExtensionJdkValidator(runningJdkVersion);
        } else {
            throw new IllegalArgumentException("Unsupported mule.jvm.version.extension.enforcementvalue: " + enforcementMode);
        }
    }

    ExtensionJdkValidator getExtensionJdkValidator() {
        return this.extensionJdkValidator;
    }

    public ReflectionCache getReflectionCache() {
        if (this.reflectionCache == null) {
            this.reflectionCache = new ReflectionCache();
        }
        return this.reflectionCache;
    }
}

