/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.documentation;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.mule.apache.xml.serialize.OutputFormat;
import org.mule.apache.xml.serialize.XMLSerializer;
import org.mule.runtime.module.extension.api.resources.documentation.ExtensionDescriptionsSerializer;
import org.mule.runtime.module.extension.api.resources.documentation.XmlExtensionDocumentation;
import org.mule.runtime.module.extension.internal.resources.documentation.DefaultXmlExtensionDocumentation;

public class DefaultExtensionDescriptionsSerializer
implements ExtensionDescriptionsSerializer {
    private JAXBContext jaxbContext;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public DefaultExtensionDescriptionsSerializer() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(DefaultExtensionDescriptionsSerializer.class.getClassLoader());
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DefaultXmlExtensionDocumentation.class});
            this.marshaller = this.jaxbContext.createMarshaller();
            this.unmarshaller = this.jaxbContext.createUnmarshaller();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    @Override
    public synchronized String serialize(XmlExtensionDocumentation dto) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            this.marshaller.marshal((Object)dto, this.getXmlSerializer(out).asContentHandler());
            return out.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized XmlExtensionDocumentation deserialize(String xml) {
        try {
            return (DefaultXmlExtensionDocumentation)this.unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized XmlExtensionDocumentation deserialize(InputStream xml) {
        try {
            return (DefaultXmlExtensionDocumentation)this.unmarshaller.unmarshal(xml);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XMLSerializer getXmlSerializer(OutputStream out) {
        OutputFormat of = new OutputFormat();
        of.setCDataElements(new String[]{"^description"});
        of.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(of);
        serializer.setOutputByteStream(out);
        return serializer;
    }

    @Override
    public String getFileName(String extensionName) {
        String key = extensionName.replace(" ", "-").toLowerCase();
        return String.format("%s-extension-descriptions.xml", key);
    }
}

