/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.LazyLookup;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthObjectStoreConfig;
import org.mule.runtime.oauth.api.OAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OAuthHandler<Dancer>
implements Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthHandler.class);
    @Inject
    protected MuleContext muleContext;
    @Inject
    protected LockFactory lockFactory;
    @Inject
    @Named(value="_muleObjectStoreManager")
    protected ObjectStoreManager objectStoreManager;
    @Inject
    protected MuleExpressionLanguage expressionEvaluator;
    @Inject
    protected ArtifactEncoding artifactEncoding;
    protected LazyValue<OAuthService> oauthService;
    protected Function<OAuthConfig, ObjectStore> objectStoreLocator;
    protected final Map<String, Dancer> dancers = new ConcurrentHashMap<String, Dancer>();
    protected boolean started = false;

    protected Map<String, String> getParameterExtractors(OAuthConfig config) {
        return this.getParameterExtractors(config.getParameterExtractors());
    }

    protected Map<String, String> getParameterExtractors(Map<Field, String> extractors) {
        return extractors.entrySet().stream().collect(Collectors.toMap(entry -> ((Field)entry.getKey()).getName(), Map.Entry::getValue));
    }

    public void initialise() throws InitialisationException {
        this.oauthService = new LazyLookup<OAuthService>(OAuthService.class, this.muleContext);
        this.objectStoreLocator = this.buildObjectStoreLocator();
    }

    public void start() throws MuleException {
        for (Dancer dancer : this.dancers.values()) {
            this.start(dancer);
        }
        this.started = true;
    }

    protected void start(Dancer dancer) throws MuleException {
        LifecycleUtils.initialiseIfNeeded(dancer, (MuleContext)this.muleContext);
        LifecycleUtils.startIfNeeded(dancer);
    }

    public void stop() throws MuleException {
        this.dancers.forEach((key, dancer) -> {
            try {
                this.disable((String)key, (Dancer)dancer);
            }
            catch (Exception e) {
                LOGGER.warn("Found exception while trying to stop OAuth dancer for config " + key, (Throwable)e);
            }
        });
        this.dancers.clear();
    }

    public void dispose() {
    }

    protected Function<OAuthConfig, ObjectStore> buildObjectStoreLocator() {
        return config -> {
            Optional<OAuthObjectStoreConfig> storeConfig = config.getStoreConfig();
            String storeName = storeConfig.map(OAuthObjectStoreConfig::getObjectStoreName).orElse("_defaultPersistentObjectStore");
            return this.objectStoreManager.getOrCreateObjectStore(storeName, ObjectStoreSettings.builder().persistent(true).build());
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disable(String ownerConfigName, Dancer dancer) {
        try {
            LifecycleUtils.stopIfNeeded(dancer);
        }
        catch (Exception e) {
            LOGGER.warn("Found exception trying to Stop OAuth dancer for config " + ownerConfigName, (Throwable)e);
        }
        finally {
            LifecycleUtils.disposeIfNeeded(dancer, (Logger)LOGGER);
        }
    }

    public Function<OAuthConfig, ObjectStore> getObjectStoreLocator() {
        return this.objectStoreLocator;
    }
}

