/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.type.context.ComponentThreadingProfilingEventContext;
import org.mule.runtime.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.execution.ExecutionTemplate;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.processor.strategy.util.ProfilingUtils;
import org.mule.runtime.core.internal.profiling.context.DefaultComponentThreadingProfilingEventContext;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.core.privileged.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.privileged.transaction.TransactionConfig;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.exception.ExceptionHandlerManager;
import org.mule.runtime.module.extension.internal.runtime.exception.ModuleExceptionHandler;
import org.mule.runtime.module.extension.internal.runtime.execution.interceptor.InterceptorChain;
import org.mule.runtime.module.extension.internal.runtime.operation.DeferredExecutorCallback;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.FutureExecutionCallbackAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.ResultTransformer;
import org.mule.runtime.module.extension.internal.runtime.operation.TracedOperationExecutionCallback;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReconnectionUtils;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExecutionMediator<M extends ComponentModel>
implements ExecutionMediator<M> {
    private final ExceptionHandlerManager exceptionEnricherManager;
    private final InterceptorChain interceptorChain;
    private final ExecutionTemplate<?> defaultExecutionTemplate = callback -> callback.process();
    private final ModuleExceptionHandler moduleExceptionHandler;
    private final MuleConfiguration muleConfiguration;
    private final NotificationDispatcher notificationDispatcher;
    private final ResultTransformer resultTransformer;
    private final ClassLoader executionClassLoader;
    private final ComponentModel operationModel;
    private final ProfilingDataProducer<ComponentThreadingProfilingEventContext, CoreEvent> threadReleaseDataProducer;
    private final ComponentTracer<CoreEvent> operationComponentTracer;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutionMediator.class);

    public DefaultExecutionMediator(ExtensionModel extensionModel, M operationModel, InterceptorChain interceptorChain, ErrorTypeRepository typeRepository, ClassLoader executionClassLoader, MuleConfiguration muleConfiguration, NotificationDispatcher notificationDispatcher, ResultTransformer resultTransformer, ProfilingDataProducer<ComponentThreadingProfilingEventContext, CoreEvent> threadReleaseDataProducer, ComponentTracer<CoreEvent> operationExecutionTracer, boolean suppressErrors) {
        this.interceptorChain = interceptorChain;
        this.exceptionEnricherManager = new ExceptionHandlerManager(extensionModel, (ComponentModel)operationModel, typeRepository);
        this.moduleExceptionHandler = new ModuleExceptionHandler((ComponentModel)operationModel, extensionModel, typeRepository, suppressErrors);
        this.muleConfiguration = Objects.requireNonNull(muleConfiguration);
        this.notificationDispatcher = notificationDispatcher;
        this.resultTransformer = resultTransformer;
        this.operationModel = operationModel;
        ClassLoader extensionClassLoader = MuleExtensionUtils.getClassLoader(extensionModel);
        executionClassLoader = RegionClassLoader.getNearestRegion((ClassLoader)executionClassLoader);
        this.executionClassLoader = executionClassLoader != null && !executionClassLoader.equals(extensionClassLoader) ? CompositeClassLoader.from((ClassLoader)extensionClassLoader, (ClassLoader)executionClassLoader) : extensionClassLoader;
        this.threadReleaseDataProducer = threadReleaseDataProducer;
        this.operationComponentTracer = operationExecutionTracer;
    }

    @Override
    public void execute(CompletableComponentExecutor<M> executor, ExecutionContextAdapter<M> context, CompletableComponentExecutor.ExecutorCallback callback) {
        try (DeferredExecutorCallback deferredCallback = new DeferredExecutorCallback(this.getDelegateExecutorCallback(this.getStats(context), callback, context));){
            this.withExecutionTemplate(context, () -> {
                this.executeWithInterceptors(executor, context, deferredCallback);
                return null;
            });
        }
        catch (Exception e) {
            callback.error((Throwable)e);
        }
        catch (Throwable t) {
            callback.error(Exceptions.wrapFatal((Throwable)t));
        }
    }

    private MutableConfigurationStats getStats(ExecutionContextAdapter<M> context) {
        MutableConfigurationStats stats = MuleExtensionUtils.getMutableConfigurationStats(context);
        if (stats != null) {
            stats.addActiveComponent();
            stats.addInflightOperation();
        }
        return stats;
    }

    private CompletableComponentExecutor.ExecutorCallback getDelegateExecutorCallback(final MutableConfigurationStats stats, final CompletableComponentExecutor.ExecutorCallback callback, final ExecutionContextAdapter<M> context) {
        return new CompletableComponentExecutor.ExecutorCallback(){

            public void complete(Object value) {
                if (stats != null) {
                    if (!MuleExtensionUtils.isConnectedStreamingOperation(DefaultExecutionMediator.this.operationModel)) {
                        stats.discountActiveComponent();
                    }
                    stats.discountInflightOperation();
                }
                try {
                    DefaultExecutionMediator.this.interceptorChain.onSuccess(context, value);
                    callback.complete(value);
                }
                catch (Throwable t) {
                    try {
                        t = DefaultExecutionMediator.this.handleError(t, context);
                    }
                    catch (Throwable throwable) {
                        callback.error(t);
                        throw throwable;
                    }
                    callback.error(t);
                }
            }

            public void error(Throwable t) {
                try {
                    t = DefaultExecutionMediator.this.handleError(t, context);
                }
                finally {
                    if (stats != null) {
                        stats.discountInflightOperation();
                        stats.discountActiveComponent();
                    }
                    callback.error(t);
                }
            }
        };
    }

    private void executeWithRetry(ExecutionContextAdapter<M> context, RetryPolicyTemplate retryPolicy, Consumer<CompletableComponentExecutor.ExecutorCallback> executeCommand, CompletableComponentExecutor.ExecutorCallback callback) {
        retryPolicy.applyPolicy(() -> {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            executeCommand.accept(new FutureExecutionCallbackAdapter(future));
            return future;
        }, e -> ReconnectionUtils.shouldRetry(e, context), e -> this.interceptorChain.onError(context, (Throwable)e), ReconnectionUtils.NULL_THROWABLE_CONSUMER, Function.identity(), context.getCurrentScheduler()).whenComplete((v, e) -> {
            if (e != null) {
                callback.error(e);
            } else {
                callback.complete(v);
            }
        });
    }

    private void executeWithInterceptors(CompletableComponentExecutor<M> executor, ExecutionContextAdapter<M> context, CompletableComponentExecutor.ExecutorCallback executorCallback) {
        RetryPolicyTemplate retryPolicy = context.getRetryPolicyTemplate().orElse(null);
        if (retryPolicy != null && retryPolicy.isEnabled()) {
            this.executeWithRetry(context, retryPolicy, callback -> this.executeCommand(executor, context, (CompletableComponentExecutor.ExecutorCallback)callback), executorCallback);
        } else {
            this.executeCommand(executor, context, executorCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(CompletableComponentExecutor<M> executor, ExecutionContextAdapter<M> context, CompletableComponentExecutor.ExecutorCallback callback) {
        Throwable t = this.interceptorChain.before(context, callback);
        if (t == null) {
            if (this.resultTransformer != null) {
                callback = new TransformingExecutionCallbackDecorator<M>(callback, context, this.resultTransformer);
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader currentClassLoader = currentThread.getContextClassLoader();
            ClassUtils.setContextClassLoader((Thread)currentThread, (ClassLoader)currentClassLoader, (ClassLoader)this.executionClassLoader);
            try {
                this.operationComponentTracer.startSpan((Event)context.getEvent());
                executor.execute(context, (CompletableComponentExecutor.ExecutorCallback)new TracedOperationExecutionCallback(context, this.operationComponentTracer, callback));
            }
            finally {
                this.profileThreadRelease(context);
                ClassUtils.setContextClassLoader((Thread)currentThread, (ClassLoader)this.executionClassLoader, (ClassLoader)currentClassLoader);
            }
        }
    }

    private void profileThreadRelease(ExecutionContextAdapter<M> context) {
        String threadName = Thread.currentThread().getName();
        String artifactId = this.muleConfiguration.getId();
        String artifactType = ProfilingUtils.getArtifactType((MuleContext)context.getMuleContext());
        this.threadReleaseDataProducer.triggerProfilingEvent((Object)context.getEvent(), event -> new DefaultComponentThreadingProfilingEventContext(event, context.getComponent().getLocation(), threadName, artifactId, artifactType, System.currentTimeMillis()));
    }

    private Throwable handleError(Throwable original, ExecutionContextAdapter context) {
        try {
            Throwable handled = this.exceptionEnricherManager.process(original);
            handled = this.moduleExceptionHandler.processException(handled);
            return this.interceptorChain.onError(context, handled);
        }
        catch (Exception handlingException) {
            LOGGER.error("An exception has been thrown during the operation error handling", (Throwable)handlingException);
            return original;
        }
    }

    Throwable applyBeforeInterceptors(ExecutionContextAdapter context) {
        try {
            return (Throwable)this.withExecutionTemplate(context, () -> {
                RetryPolicyTemplate retryPolicy = context.getRetryPolicyTemplate().orElse(null);
                if (retryPolicy != null && retryPolicy.isEnabled()) {
                    final CompletableFuture result = new CompletableFuture();
                    this.executeWithRetry(context, retryPolicy, callback -> {
                        Throwable t = this.interceptorChain.before(context, (CompletableComponentExecutor.ExecutorCallback)callback);
                        if (t == null) {
                            result.complete(null);
                        }
                    }, new CompletableComponentExecutor.ExecutorCallback(){

                        public void complete(Object value) {
                            result.complete((Throwable)value);
                        }

                        public void error(Throwable e) {
                            result.completeExceptionally(e);
                        }
                    });
                    return (Throwable)result.get();
                }
                return this.interceptorChain.before(context, null);
            });
        }
        catch (Exception e) {
            return e;
        }
    }

    void applyAfterInterceptors(ExecutionContext executionContext) {
        this.interceptorChain.abort(executionContext);
    }

    private <T> T withExecutionTemplate(ExecutionContextAdapter<ComponentModel> context, ExecutionCallback<T> callback) throws Exception {
        if (context.getTransactionConfig().isPresent()) {
            return (T)TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleConfiguration)this.muleConfiguration, (NotificationDispatcher)this.notificationDispatcher, (TransactionConfig)context.getTransactionConfig().orElseThrow()).execute(callback);
        }
        return (T)this.defaultExecutionTemplate.execute(callback);
    }

    private static class TransformingExecutionCallbackDecorator<M extends ComponentModel>
    implements CompletableComponentExecutor.ExecutorCallback {
        private final CompletableComponentExecutor.ExecutorCallback delegate;
        private final ExecutionContextAdapter<M> executionContext;
        private final ResultTransformer resultTransformer;

        public TransformingExecutionCallbackDecorator(CompletableComponentExecutor.ExecutorCallback delegate, ExecutionContextAdapter<M> executionContext, ResultTransformer resultTransformer) {
            this.delegate = delegate;
            this.executionContext = executionContext;
            this.resultTransformer = resultTransformer;
        }

        public void complete(Object value) {
            try {
                this.delegate.complete(this.resultTransformer.apply(this.executionContext, value));
            }
            catch (Exception e) {
                this.delegate.error((Throwable)e);
            }
        }

        public void error(Throwable e) {
            this.delegate.error(e);
        }
    }
}

