/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import jakarta.inject.Inject;
import java.util.List;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.EntityMetadataProvider;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.exception.EnrichedErrorMapping;
import org.mule.runtime.core.internal.exception.ErrorMappingsAware;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.metadata.EntityMetadataMediator;
import org.mule.runtime.module.extension.internal.runtime.ExecutionTypeMapper;
import org.mule.runtime.module.extension.internal.runtime.operation.ComponentMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalOperationException;
import org.mule.runtime.module.extension.internal.runtime.operation.ResultTransformer;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class OperationMessageProcessor
extends ComponentMessageProcessor<OperationModel>
implements EntityMetadataProvider,
ErrorMappingsAware {
    static final String INVALID_TARGET_MESSAGE = "Root component '%s' defines an invalid usage of operation '%s' which uses %s as %s";
    private EntityMetadataMediator entityMetadataMediator;
    private final List<EnrichedErrorMapping> errorMappings;
    @Inject
    private FeatureFlaggingService featureFlaggingService;

    public OperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ValueResolver<ConfigurationProvider> configurationProviderResolver, String target, String targetValue, List<EnrichedErrorMapping> errorMappings, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, RetryPolicyTemplate retryPolicyTemplate, MessageProcessorChain nestedChain, ClassLoader classLoader, ExtensionManager extensionManager, ReflectionCache reflectionCache) {
        this(extensionModel, operationModel, configurationProviderResolver, target, targetValue, errorMappings, resolverSet, cursorProviderFactory, retryPolicyTemplate, nestedChain, classLoader, extensionManager, reflectionCache, null, -1L);
    }

    public OperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ValueResolver<ConfigurationProvider> configurationProviderResolver, String target, String targetValue, List<EnrichedErrorMapping> errorMappings, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, RetryPolicyTemplate retryPolicyTemplate, MessageProcessorChain nestedChain, ClassLoader classLoader, ExtensionManager extensionManager, ReflectionCache reflectionCache, ResultTransformer resultTransformer, long terminationTimeout) {
        super(extensionModel, operationModel, configurationProviderResolver, target, targetValue, resolverSet, cursorProviderFactory, retryPolicyTemplate, nestedChain, classLoader, extensionManager, reflectionCache, resultTransformer, terminationTimeout);
        this.errorMappings = errorMappings;
    }

    @Override
    protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
        this.validatePolicyIsolation(configurationProvider);
        ConfigurationModel configurationModel = configurationProvider.getConfigurationModel();
        if (!configurationModel.getOperationModel(((OperationModel)this.componentModel).getName()).isPresent() && !configurationProvider.getExtensionModel().getOperationModel(((OperationModel)this.componentModel).getName()).isPresent()) {
            throw new IllegalOperationException(String.format("Root component '%s' defines an usage of operation '%s' which points to configuration '%s'. The selected config does not support that operation.", this.getLocation().getRootContainerName(), ((OperationModel)this.componentModel).getName(), configurationProvider.getName()));
        }
    }

    private void validatePolicyIsolation(ConfigurationProvider configurationProvider) {
        if (this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ENABLE_POLICY_ISOLATION) && this.muleContext.getArtifactType().equals((Object)ArtifactType.POLICY) && configurationProvider.getExtensionModel() != this.extensionModel) {
            throw new IllegalOperationException(String.format("Root component '%s' defines an usage of operation '%s' which points to configuration '%s'. The selected config is not part of the policy declaration and cannot be shared.", this.getLocation().getRootContainerName(), ((OperationModel)this.componentModel).getName(), configurationProvider.getName()));
        }
    }

    @Override
    public ReactiveProcessor.ProcessingType getInnerProcessingType() {
        ReactiveProcessor.ProcessingType processingType = ExecutionTypeMapper.asProcessingType(((OperationModel)this.componentModel).getExecutionType());
        if (processingType == ReactiveProcessor.ProcessingType.CPU_LITE && !((OperationModel)this.componentModel).isBlocking()) {
            return ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC;
        }
        return processingType;
    }

    @Override
    protected boolean mayCompleteInDifferentThread() {
        if (!this.isBlocking()) {
            return true;
        }
        return super.mayCompleteInDifferentThread();
    }

    @Override
    protected boolean isBlocking() {
        return ((OperationModel)this.componentModel).isBlocking();
    }

    public List<EnrichedErrorMapping> getErrorMappings() {
        return this.errorMappings;
    }

    @Override
    protected void initializeForFatTooling() {
        this.entityMetadataMediator = new EntityMetadataMediator((OperationModel)this.componentModel);
        super.initializeForFatTooling();
    }

    public MetadataResult<MetadataKeysContainer> getEntityKeys() throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.entityMetadataMediator.getEntityKeys((MetadataContext)context)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onKeys()});
        }
    }

    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(MetadataKey key) throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.entityMetadataMediator.getEntityMetadata((MetadataContext)context, key)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onKeys()});
        }
    }
}

