/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import com.google.common.collect.ImmutableBiMap;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.ast.api.MetadataTypeAdapter;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ComponentParameterizationUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.resolver.ValueResolverFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class ResolverSetUtils {
    private static final String PAYLOAD_EXPRESSION = "#[payload]";
    private static final String APPLICATION_JAVA = "application/java";

    private ResolverSetUtils() {
    }

    public static ResolverSet getResolverSetFromStaticValues(ParameterizedModel parameterizedModel, Map<String, Object> parameters, MuleContext muleContext, boolean disableValidations, ReflectionCache reflectionCache, ExpressionManager expressionManager, String parametersOwner, ArtifactEncoding artifactEncoding) throws MuleException {
        return ResolverSetUtils.getResolverSetFromComponentParameterization(ComponentParameterizationUtils.createComponentParameterization(parameterizedModel, parameters), muleContext, disableValidations, reflectionCache, expressionManager, parametersOwner, artifactEncoding);
    }

    public static ResolverSet getResolverSetFromComponentParameterization(ComponentParameterization<?> componentParameterization, MuleContext muleContext, boolean disableValidations, ReflectionCache reflectionCache, ExpressionManager expressionManager, String parametersOwner, ArtifactEncoding artifactEncoding) throws MuleException {
        return ResolverSetUtils.getResolverSetFromParameters(componentParameterization.getModel(), (arg_0, arg_1) -> componentParameterization.getParameter(arg_0, arg_1), muleContext, disableValidations, reflectionCache, expressionManager, parametersOwner, new ValueResolverFactory(), artifactEncoding);
    }

    public static ResolverSet getResolverSetFromParameters(ParameterizedModel model, BiFunction<ParameterGroupModel, ParameterModel, Object> params, MuleContext muleContext, boolean disableValidations, ReflectionCache reflectionCache, ExpressionManager expressionManager, String parametersOwner, ValueResolverFactory valueResolverFactory, ArtifactEncoding artifactEncoding) throws MuleException {
        HashMap<String, ValueResolver> resolvers = new HashMap<String, ValueResolver>();
        for (ParameterGroupModel parameterGroupModel : model.getParameterGroupModels()) {
            resolvers.putAll(ResolverSetUtils.getParameterGroupValueResolvers(params, parameterGroupModel, reflectionCache, muleContext, valueResolverFactory, artifactEncoding));
        }
        return ParametersResolver.fromValues(resolvers, muleContext, disableValidations, reflectionCache, expressionManager, parametersOwner).getParametersAsResolverSet(model, muleContext);
    }

    private static Map<String, ValueResolver> getParameterGroupValueResolvers(BiFunction<ParameterGroupModel, ParameterModel, Object> params, ParameterGroupModel parameterGroupModel, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory, ArtifactEncoding artifactEncoding) {
        Optional<Class<?>> parameterGroupDeclaringClass;
        Optional parameterGroupModelProperty;
        Map<String, ValueResolver> parameterGroupParametersValueResolvers = ResolverSetUtils.getParameterGroupParametersValueResolvers(parameterGroupModel, params, reflectionCache, muleContext, valueResolverFactory, artifactEncoding);
        if (parameterGroupModel.isShowInDsl() && !parameterGroupParametersValueResolvers.isEmpty() && (parameterGroupModelProperty = parameterGroupModel.getModelProperty(ParameterGroupModelProperty.class)).isPresent() && (parameterGroupDeclaringClass = ((ParameterGroupModelProperty)parameterGroupModelProperty.get()).getDescriptor().getType().getDeclaringClass()).isPresent()) {
            DefaultObjectBuilder defaultObjectBuilder = new DefaultObjectBuilder(parameterGroupDeclaringClass.get(), reflectionCache);
            defaultObjectBuilder.setEncoding(artifactEncoding.getDefaultEncoding().displayName());
            for (Map.Entry<String, ValueResolver> stringValueResolverEntry : parameterGroupParametersValueResolvers.entrySet()) {
                defaultObjectBuilder.addPropertyResolver(stringValueResolverEntry.getKey(), (ValueResolver<Object>)stringValueResolverEntry.getValue());
            }
            ObjectBuilderValueResolver objectBuilderValuerResolver = new ObjectBuilderValueResolver(defaultObjectBuilder, muleContext);
            return ImmutableBiMap.of((Object)ResolverSetUtils.getGroupName((ParameterGroupModelProperty)parameterGroupModelProperty.orElseThrow()), objectBuilderValuerResolver);
        }
        return parameterGroupParametersValueResolvers;
    }

    private static String getGroupName(ParameterGroupModelProperty groupModelProperty) {
        AnnotatedElement container = groupModelProperty.getDescriptor().getContainer();
        if (container instanceof Field) {
            Field f = (Field)container;
            return f.getName();
        }
        if (container instanceof Parameter) {
            Parameter p = (Parameter)container;
            return p.getName();
        }
        throw new IllegalArgumentException("Group container of unexpected type: " + String.valueOf(container));
    }

    private static Map<String, ValueResolver> getParameterGroupParametersValueResolvers(ParameterGroupModel parameterGroupModel, BiFunction<ParameterGroupModel, ParameterModel, Object> params, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory, ArtifactEncoding artifactEncoding) {
        HashMap<String, ValueResolver> parameterGroupParametersValueResolvers = new HashMap<String, ValueResolver>();
        for (ParameterModel parameterModel : parameterGroupModel.getParameterModels()) {
            valueResolverFactory.ofNullableParameter(params, parameterGroupModel, parameterModel, (CheckedFunction<Object, ValueResolver>)((CheckedFunction)value -> ResolverSetUtils.getParameterValueResolver(parameterModel.getName(), parameterModel.getType(), parameterModel.getExpressionSupport(), value, parameterModel.getModelProperties(), reflectionCache, muleContext, valueResolverFactory, artifactEncoding, ResolverSetUtils.acceptsReferences(parameterModel)))).ifPresent(resolver -> parameterGroupParametersValueResolvers.put(parameterModel.getName(), (ValueResolver)resolver));
        }
        return parameterGroupParametersValueResolvers;
    }

    private static <T> ValueResolver<T> getParameterValueResolver(String parameterName, MetadataType type, ExpressionSupport expressionSupport, T value, Set<ModelProperty> modelProperties, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory, ArtifactEncoding artifactEncoding, boolean acceptsReferences) throws InitialisationException {
        ValueResolver<T> resolverReference;
        if (type.getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
            resolverReference = ResolverSetUtils.getJavaParameterValueResolver(parameterName, type, expressionSupport, value, modelProperties, reflectionCache, muleContext, valueResolverFactory, artifactEncoding, acceptsReferences);
        } else {
            Object convertedValue = ResolverSetUtils.convertValueWithExpressionLanguage(value, type, expressionSupport, (ExpressionManager)muleContext.getExpressionManager());
            resolverReference = ResolverSetUtils.getValueResolverFor(parameterName, type, convertedValue, null, ExpressionSupport.NOT_SUPPORTED, false, modelProperties, false, valueResolverFactory);
        }
        LifecycleUtils.initialiseIfNeeded(resolverReference, (MuleContext)muleContext);
        return resolverReference;
    }

    private static <T> ValueResolver<T> getJavaParameterValueResolver(final String parameterName, MetadataType type, final ExpressionSupport expressionSupport, final T value, final Set<ModelProperty> modelProperties, final ReflectionCache reflectionCache, final MuleContext muleContext, final ValueResolverFactory valueResolverFactory, final ArtifactEncoding artifactEncoding, final boolean acceptsReferences) {
        final Reference resolverReference = new Reference();
        type.accept(new MetadataTypeVisitor(){

            public void visitArrayType(ArrayType arrayType) {
                boolean effectivelyAcceptReferences = acceptsReferences;
                try {
                    ValueResolver<Object> resolver;
                    if (value instanceof Collection) {
                        Collection collection = (Collection)value;
                        resolver = ResolverSetUtils.getParameterValueResolverForCollection(parameterName, arrayType, expressionSupport, collection, reflectionCache, muleContext, valueResolverFactory, artifactEncoding);
                        effectivelyAcceptReferences = false;
                    } else {
                        resolver = new StaticValueResolver<Object>(value);
                    }
                    resolverReference.set(this.valueResolverFor(parameterName, (MetadataType)arrayType, ResolverSetUtils.resolveAndInjectIfStatic(resolver, muleContext), modelProperties, valueResolverFactory, effectivelyAcceptReferences));
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }

            public void visitObject(ObjectType objectType) {
                boolean effectivelyAcceptReferences = acceptsReferences;
                try {
                    ValueResolver<Object> resolver;
                    if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                        if (value instanceof Map) {
                            Map map = (Map)value;
                            resolver = ResolverSetUtils.getParameterValueResolverForMap(parameterName, objectType, expressionSupport, map, reflectionCache, muleContext, valueResolverFactory, artifactEncoding);
                            effectivelyAcceptReferences = false;
                        } else {
                            resolver = new StaticValueResolver<Object>(value);
                        }
                    } else {
                        Optional pojoResolver = ResolverSetUtils.getPojoParameterValueResolver(parameterName, objectType, expressionSupport, value, reflectionCache, muleContext, valueResolverFactory, artifactEncoding);
                        if (pojoResolver.isPresent()) {
                            resolver = pojoResolver.get();
                            effectivelyAcceptReferences = false;
                        } else {
                            resolver = new StaticValueResolver<Object>(value);
                        }
                    }
                    resolverReference.set(this.valueResolverFor(parameterName, (MetadataType)objectType, ResolverSetUtils.resolveAndInjectIfStatic(resolver, muleContext), modelProperties, valueResolverFactory, effectivelyAcceptReferences));
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }

            protected void defaultVisit(MetadataType metadataType) {
                resolverReference.set(this.valueResolverFor(parameterName, metadataType, value, modelProperties, valueResolverFactory, acceptsReferences));
            }

            private ValueResolver<T> valueResolverFor(String parameterName2, MetadataType metadataType, Object value2, Set<ModelProperty> modelProperties2, ValueResolverFactory valueResolverFactory2, boolean acceptsReferences2) {
                return ResolverSetUtils.getValueResolverFor(parameterName2, metadataType, value2, MetadataTypeUtils.getDefaultValue((MetadataType)metadataType), ExtensionMetadataTypeUtils.getExpressionSupport((MetadataType)metadataType), false, modelProperties2, acceptsReferences2, valueResolverFactory2);
            }
        });
        return (ValueResolver)resolverReference.get();
    }

    private static Object convertValueWithExpressionLanguage(Object value, MetadataType type, ExpressionSupport expressionSupport, ExpressionManager expressionManager) {
        TypedValue tv;
        MediaType mimeType = ResolverSetUtils.getFirstValidMimeType(type);
        DataType expectedOutputType = DataType.builder().type(ExtensionMetadataTypeUtils.getType((MetadataType)type).orElse(Object.class)).mediaType(mimeType).build();
        if (!ExpressionSupport.NOT_SUPPORTED.equals((Object)expressionSupport) && MuleExtensionUtils.isExpression(value)) {
            if (PAYLOAD_EXPRESSION.equals(value)) {
                return null;
            }
            return expressionManager.evaluate(value.toString(), expectedOutputType, BindingContextUtils.NULL_BINDING_CONTEXT).getValue();
        }
        TypedValue typedValue = value instanceof TypedValue ? (tv = (TypedValue)value) : new TypedValue(value, DataType.builder().type(value.getClass()).mediaType(mimeType).build());
        return expressionManager.evaluate(PAYLOAD_EXPRESSION, expectedOutputType, BindingContext.builder().addBinding("payload", typedValue).build()).getValue();
    }

    private static MediaType getFirstValidMimeType(MetadataType type) {
        Collection validMimeTypes = type.getMetadataFormat().getValidMimeTypes();
        String mimeType = validMimeTypes.isEmpty() ? APPLICATION_JAVA : (String)validMimeTypes.iterator().next();
        return MediaType.parse((String)mimeType);
    }

    private static <T> ValueResolver<T> getValueResolverFor(String parameterName, MetadataType metadataType, Object value, Object defaultValue, ExpressionSupport expressionSupport, boolean required, Set<ModelProperty> modelProperties, boolean acceptsReferences, ValueResolverFactory valueResolverFactory) {
        return valueResolverFactory.of(parameterName, metadataType, value, defaultValue, expressionSupport, required, modelProperties, acceptsReferences);
    }

    private static Object resolveAndInjectIfStatic(ValueResolver valueResolver, MuleContext muleContext) {
        if (valueResolver.isDynamic()) {
            return valueResolver;
        }
        return FunctionalUtils.withNullEvent(event -> {
            try (ValueResolvingContext ctx = ValueResolvingContext.builder(event, (ExpressionManager)muleContext.getExpressionManager()).build();){
                Object staticProduct = valueResolver.resolve(ctx);
                if (staticProduct != null) {
                    muleContext.getInjector().inject(staticProduct);
                }
                Object t = staticProduct;
                return t;
            }
        });
    }

    private static <T> Optional<ValueResolver<T>> getPojoParameterValueResolver(String parameterName, ObjectType objectType, ExpressionSupport expressionSupport, Object value, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory, ArtifactEncoding artifactEncoding) throws InitialisationException {
        Optional pojoClass = ExtensionMetadataTypeUtils.getType((MetadataType)objectType);
        if (pojoClass.isPresent()) {
            if (value instanceof Map) {
                Map valuesMap = (Map)value;
                DefaultObjectBuilder objectBuilder = new DefaultObjectBuilder((Class)pojoClass.get(), reflectionCache);
                objectBuilder.setEncoding(artifactEncoding.getDefaultEncoding().displayName());
                for (ObjectFieldType objectFieldType : objectType.getFields()) {
                    if (!valuesMap.containsKey(objectFieldType.getKey().getName().toString())) continue;
                    objectBuilder.addPropertyResolver(objectFieldType.getKey().getName().toString(), ResolverSetUtils.getParameterValueResolver(parameterName, objectFieldType.getValue(), expressionSupport, valuesMap.get(objectFieldType.getKey().getName().toString()), Collections.emptySet(), reflectionCache, muleContext, valueResolverFactory, artifactEncoding, false));
                }
                return Optional.of(new ObjectBuilderValueResolver(objectBuilder, muleContext));
            }
            if (value instanceof ComponentParameterization) {
                ComponentParameterization valuesParameterization = (ComponentParameterization)value;
                DefaultObjectBuilder objectBuilder = null;
                if (ResolverSetUtils.isInstantiableType((MetadataType)objectType)) {
                    objectBuilder = new DefaultObjectBuilder((Class)pojoClass.get(), reflectionCache);
                } else {
                    MetadataTypeAdapter metadataTypeAdapter;
                    Optional parameterizedType;
                    ParameterizedModel objectFieldType = valuesParameterization.getModel();
                    if (objectFieldType instanceof MetadataTypeAdapter && (parameterizedType = ExtensionMetadataTypeUtils.getType((MetadataType)(metadataTypeAdapter = (MetadataTypeAdapter)objectFieldType).getType())).isPresent()) {
                        objectBuilder = new DefaultObjectBuilder((Class)parameterizedType.get(), reflectionCache);
                        objectBuilder.setEncoding(artifactEncoding.getDefaultEncoding().displayName());
                        objectType = (ObjectType)metadataTypeAdapter.getType();
                    }
                }
                if (objectBuilder == null) {
                    throw new IllegalArgumentException(String.format("Class %s cannot be instantiated.", pojoClass.get()));
                }
                String aliasName = NameUtils.getAliasName((MetadataType)objectType);
                for (ObjectFieldType objectFieldType : objectType.getFields()) {
                    Object paramValue = valuesParameterization.getParameter(aliasName, objectFieldType.getKey().getName().getLocalPart());
                    if (paramValue == null) continue;
                    objectBuilder.addPropertyResolver(objectFieldType.getKey().getName().toString(), ResolverSetUtils.getParameterValueResolver(parameterName, objectFieldType.getValue(), ResolverSetUtils.retrieveExpressionSupport(objectFieldType), paramValue, Collections.emptySet(), reflectionCache, muleContext, valueResolverFactory, artifactEncoding, ResolverSetUtils.acceptsReferences(objectFieldType.getValue())));
                }
                return Optional.of(new ObjectBuilderValueResolver(objectBuilder, muleContext));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean acceptsReferences(MetadataType type) {
        return type.getAnnotation(TypeDslAnnotation.class).map(TypeDslAnnotation::allowsTopLevelDefinition).orElse(false);
    }

    private static ExpressionSupport retrieveExpressionSupport(ObjectFieldType objectFieldType) {
        return objectFieldType.getAnnotation(ExpressionSupportAnnotation.class).map(ExpressionSupportAnnotation::getExpressionSupport).orElse(ExpressionSupport.NOT_SUPPORTED);
    }

    private static boolean isInstantiableType(MetadataType type) {
        return type.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::isInstantiable).orElse(false);
    }

    private static ValueResolver getParameterValueResolverForCollection(String parameterName, ArrayType arrayType, ExpressionSupport expressionSupport, Collection collection, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory, ArtifactEncoding artifactEncoding) throws MuleException {
        Optional expectedType = ExtensionMetadataTypeUtils.getType((MetadataType)arrayType);
        if (expectedType.isPresent()) {
            Class type = (Class)expectedType.get();
            ArrayList itemsResolvers = new ArrayList();
            for (Object collectionItem : collection) {
                itemsResolvers.add(ResolverSetUtils.getParameterValueResolver(parameterName, arrayType.getType(), expressionSupport, collectionItem, Collections.emptySet(), reflectionCache, muleContext, valueResolverFactory, artifactEncoding, false));
            }
            return CollectionValueResolver.of(type, itemsResolvers);
        }
        return new StaticValueResolver<Collection>(collection);
    }

    private static ValueResolver getParameterValueResolverForMap(String parameterName, ObjectType type, ExpressionSupport expressionSupport, Map<Object, Object> map, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory, ArtifactEncoding artifactEncoding) throws MuleException {
        Class mapClass = (Class)ExtensionMetadataTypeUtils.getType((MetadataType)type).orElseThrow();
        MetadataType valueType = type.getOpenRestriction().orElse(null);
        Function<Object, ValueResolver> valueValueResolverFunction = valueType != null ? value -> {
            try {
                return ResolverSetUtils.getParameterValueResolver(parameterName, valueType, expressionSupport, value, Collections.emptySet(), reflectionCache, muleContext, valueResolverFactory, artifactEncoding, false);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        } : value -> new StaticValueResolver<Object>(value);
        ArrayList keyResolvers = new ArrayList();
        ArrayList valueResolvers = new ArrayList();
        for (Map.Entry<Object, Object> mapEntry : map.entrySet()) {
            keyResolvers.add(new StaticValueResolver<String>(mapEntry.getKey().toString()));
            valueResolvers.add(valueValueResolverFunction.apply(mapEntry.getValue()));
        }
        return MapValueResolver.of(mapClass, keyResolvers, valueResolvers, reflectionCache, muleContext);
    }

    private static boolean acceptsReferences(ParameterModel parameterModel) {
        return parameterModel.getDslConfiguration().allowsReferences();
    }

    public static Map<String, Object> evaluate(ResolverSet resolverSet, Optional<ConfigurationInstance> configurationInstance, CoreEvent event) {
        ValueResolvingContext.Builder ctxBuilder = ValueResolvingContext.builder(event);
        configurationInstance.ifPresent(ctxBuilder::withConfig);
        ValueResolvingContext ctx = ctxBuilder.build();
        try {
            Map<String, Object> map = resolverSet.resolve(ctx).asMap();
            if (ctx != null) {
                ctx.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Exception found while evaluating parameters:" + e.getMessage())), (Throwable)e);
            }
        }
    }
}

