/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingException;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.config.ResolverSetBasedParameterResolver;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ParameterGroupObjectBuilder;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class DesignTimeParameterValueResolver
extends ResolverSetBasedParameterResolver {
    private final ParameterizedModel model;
    private final ParameterGroupObjectBuilderAdapter paramGroupObjectBuilderAdapter;
    private final LazyValue<Map<String, String>> shownInDslParameterGroups;

    public DesignTimeParameterValueResolver(ResolverSet resolverSet, ParameterizedModel parameterizedModel, ReflectionCache reflectionCache, ExpressionManager expressionManager, Supplier<Optional<ConfigurationInstance>> configuration) {
        super(resolverSet, parameterizedModel, reflectionCache, expressionManager);
        this.model = parameterizedModel;
        this.paramGroupObjectBuilderAdapter = new ParameterGroupObjectBuilderAdapter(reflectionCache, expressionManager, resolverSet, configuration);
        this.shownInDslParameterGroups = new LazyValue(() -> IntrospectionUtils.getShowInDslParameters(parameterizedModel));
    }

    @Override
    protected Object resolveFromParameterGroup(String parameterName) throws ValueResolvingException, MuleException {
        Optional<Pair<ParameterGroupDescriptor, ParameterGroupModel>> parameterGroupDescriptor = this.getParameterGroupDescriptor(parameterName);
        if (parameterGroupDescriptor.isPresent()) {
            if (((ParameterGroupModel)parameterGroupDescriptor.get().getSecond()).isShowInDsl()) {
                return this.resolveFromResolverSetWithAdjustedContainerName((ParameterGroupDescriptor)parameterGroupDescriptor.get().getFirst());
            }
            return this.resolveFromParameterGroupNotShownInDsl((ParameterGroupDescriptor)parameterGroupDescriptor.get().getFirst(), parameterName);
        }
        if (!((Map)this.shownInDslParameterGroups.get()).containsKey(parameterName)) {
            return null;
        }
        return super.resolveFromParameterGroup(parameterName);
    }

    private Optional<Pair<ParameterGroupDescriptor, ParameterGroupModel>> getParameterGroupDescriptor(String parameterGroupName) {
        return this.model.getParameterGroupModels().stream().filter(pgm -> parameterGroupName.equals(pgm.getName())).findFirst().flatMap(pgm -> pgm.getModelProperty(ParameterGroupModelProperty.class).map(mp -> new Pair((Object)mp.getDescriptor(), pgm)));
    }

    private Object resolveFromParameterGroupNotShownInDsl(ParameterGroupDescriptor parameterGroupDescriptor, String parameterName) throws ValueResolvingException {
        try {
            return this.paramGroupObjectBuilderAdapter.build(parameterGroupDescriptor);
        }
        catch (MuleException e) {
            throw new ValueResolvingException(String.format("Error occurred trying to resolve value for the parameter [%s]", parameterName), e);
        }
    }

    private Object resolveFromResolverSetWithAdjustedContainerName(ParameterGroupDescriptor parameterGroupDescriptor) throws ValueResolvingException {
        return this.getParameterValue(IntrospectionUtils.getContainerName(parameterGroupDescriptor.getContainer()));
    }

    private static class ParameterGroupObjectBuilderAdapter {
        private final ReflectionCache reflectionCache;
        private final ExpressionManager expressionManager;
        private final LazyValue<Either<MuleException, ResolverSetResult>> resultLazyValue;
        private final LazyValue<Optional<ConfigurationInstance>> configurationInstance;

        private ParameterGroupObjectBuilderAdapter(ReflectionCache reflectionCache, ExpressionManager expressionManager, ResolverSet resolverSet, Supplier<Optional<ConfigurationInstance>> configuration) {
            this.reflectionCache = reflectionCache;
            this.expressionManager = expressionManager;
            this.configurationInstance = new LazyValue(configuration);
            this.resultLazyValue = new LazyValue(() -> {
                ValueResolvingContext ctx = this.buildResolvingContext();
                try {
                    Either either = Either.right((Object)resolverSet.resolve(ctx));
                    if (ctx != null) {
                        ctx.close();
                    }
                    return either;
                }
                catch (Throwable throwable) {
                    try {
                        if (ctx != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (MuleException e) {
                        return Either.left((Object)((Object)e));
                    }
                }
            });
        }

        private ValueResolvingContext buildResolvingContext() {
            ValueResolvingContext.Builder builder = ValueResolvingContext.builder(NullEventFactory.getNullEvent()).withExpressionManager(this.expressionManager);
            ((Optional)this.configurationInstance.get()).ifPresent(builder::withConfig);
            return builder.build();
        }

        private <T> T build(ParameterGroupDescriptor descriptor) throws MuleException {
            Either resolverSetResultEither = (Either)this.resultLazyValue.get();
            if (resolverSetResultEither.isLeft()) {
                throw (MuleException)((Object)resolverSetResultEither.getLeft());
            }
            return this.doBuild(descriptor, (ResolverSetResult)resolverSetResultEither.getRight());
        }

        private <T> T doBuild(ParameterGroupDescriptor descriptor, ResolverSetResult resolverSetResult) throws MuleException {
            return new ParameterGroupObjectBuilder(descriptor, this.reflectionCache, this.expressionManager).build(resolverSetResult);
        }
    }
}

