/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingException;

/**
 * A {@link ValueResolvingException} that can be used by a {@link ParameterValueResolver} to indicate that the failure was because
 * there was no {@link ValueResolver} associated to a given parameter, rather than any other kind of resolution exception.
 *
 * @since 4.10.0
 */
public class ValueResolverNotFoundException extends ValueResolvingException {

  public ValueResolverNotFoundException(String message) {
    super(message);
  }
}
