/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver.resolver;

import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.core.internal.util.func.CheckedFunction;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.privileged.util.ComponentDeclarationUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.loader.java.property.ExclusiveOptionalModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes.StackedTypesModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConfigurationProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedParameterResolverValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionTypedValueValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterResolverValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.RequiredParameterValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticLiteralValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypedValueValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.resolver.ValueResolverFactoryTypeVisitor;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.sdk.api.runtime.parameter.Literal;

public class ValueResolverFactory {
    public <T> ValueResolver<T> of(String parameterName, MetadataType expectedType, Object value, Object defaultValue, ExpressionSupport expressionSupport, boolean required, Set<ModelProperty> modelProperties) {
        return this.of(parameterName, expectedType, value, defaultValue, expressionSupport, required, modelProperties, true);
    }

    public <T> ValueResolver<T> of(String parameterName, MetadataType expectedType, Object value, Object defaultValue, ExpressionSupport expressionSupport, boolean required, Set<ModelProperty> modelProperties, boolean acceptsReferences) {
        ValueResolver<ConfigurationProvider> resolver;
        if (value instanceof ValueResolver) {
            return (ValueResolver)value;
        }
        Class<Object> expectedClass = ExtensionMetadataTypeUtils.getType((MetadataType)expectedType).orElse(Object.class);
        if (expectedClass.equals(ConfigurationProvider.class)) {
            resolver = new ConfigurationProviderValueResolver((String)value);
        } else if (MuleExtensionUtils.isExpression(value)) {
            String expression = (String)value;
            resolver = this.getExpressionBasedValueResolver(expectedType, expression, modelProperties, expectedClass);
            if (required || this.isRequiredByExclusiveOptional(modelProperties)) {
                resolver = new RequiredParameterValueResolverWrapper<ConfigurationProvider>(resolver, parameterName, expression);
            }
        } else {
            resolver = this.getStaticValueResolver(parameterName, expectedType, value, defaultValue, modelProperties, acceptsReferences, expectedClass);
        }
        if (resolver.isDynamic() && expressionSupport == ExpressionSupport.NOT_SUPPORTED) {
            throw new IllegalArgumentException(String.format("An expression value was given for parameter '%s' but it doesn't support expressions", parameterName));
        }
        if (!resolver.isDynamic() && expressionSupport == ExpressionSupport.REQUIRED && required) {
            throw new IllegalArgumentException(String.format("A fixed value was given for parameter '%s' but it only supports expressions", parameterName));
        }
        return resolver;
    }

    public Optional<ValueResolver> ofNullableParameter(BiFunction<ParameterGroupModel, ParameterModel, Object> params, ParameterGroupModel parameterGroupModel, ParameterModel parameterModel, CheckedFunction<Object, ValueResolver> resolverFunction) {
        Object value = params.apply(parameterGroupModel, parameterModel);
        return value != null ? Optional.ofNullable((ValueResolver)resolverFunction.apply(value)) : Optional.empty();
    }

    private ValueResolver getExpressionBasedValueResolver(MetadataType expectedType, String value, Set<ModelProperty> modelProperties, Class<?> expectedClass) {
        Optional<StackedTypesModelProperty> stackedTypesModelProperty = StackedTypesModelProperty.getStackedTypesModelProperty(modelProperties);
        ValueResolver<ParameterResolver<?>> resolver = stackedTypesModelProperty.isPresent() ? stackedTypesModelProperty.get().getValueResolverFactory().getExpressionBasedValueResolver(value, expectedClass) : (IntrospectionUtils.isParameterResolver(expectedType) ? new ExpressionBasedParameterResolverValueResolver(value, expectedClass, IntrospectionUtils.toDataType(expectedType)) : (IntrospectionUtils.isTypedValue(expectedType) ? new ExpressionTypedValueValueResolver(value, expectedClass) : (IntrospectionUtils.isLiteral(expectedType) || ComponentDeclarationUtils.isTargetParameter(modelProperties) ? new StaticLiteralValueResolver(value, expectedClass) : new TypeSafeExpressionValueResolver(value, expectedClass, IntrospectionUtils.toDataType(expectedType)))));
        return resolver;
    }

    private ValueResolver getStaticValueResolver(String parameterName, MetadataType expectedType, Object value, Object defaultValue, Set<ModelProperty> modelProperties, boolean acceptsReferences, Class<?> expectedClass) {
        ValueResolver resolver;
        StackedTypesModelProperty property;
        Optional<ValueResolver> optionalResolver;
        Optional<StackedTypesModelProperty> optionalStackedTypeModelProperty = StackedTypesModelProperty.getStackedTypesModelProperty(modelProperties);
        if (optionalStackedTypeModelProperty.isPresent() && (optionalResolver = (property = optionalStackedTypeModelProperty.get()).getValueResolverFactory().getStaticValueResolver(value, Literal.class)).isPresent()) {
            return optionalResolver.get();
        }
        if (IntrospectionUtils.isLiteral(expectedType)) {
            return new StaticLiteralValueResolver(value != null ? value.toString() : null, expectedClass);
        }
        ValueResolver valueResolver = resolver = value != null ? this.getValueResolverFromMetadataType(parameterName, expectedType, value, defaultValue, acceptsReferences, expectedClass) : StaticValueResolver.fromUnwrapped(defaultValue);
        if (optionalStackedTypeModelProperty.isPresent()) {
            resolver = optionalStackedTypeModelProperty.get().getValueResolverFactory().getWrapperValueResolver(resolver);
        } else if (IntrospectionUtils.isParameterResolver(expectedType)) {
            resolver = new ParameterResolverValueResolverWrapper(resolver);
        } else if (IntrospectionUtils.isTypedValue(expectedType)) {
            resolver = new TypedValueValueResolverWrapper(resolver);
        }
        return resolver;
    }

    private boolean isRequiredByExclusiveOptional(Set<ModelProperty> modelProperties) {
        return modelProperties.stream().anyMatch(modelProperty -> modelProperty instanceof ExclusiveOptionalModelProperty && ((ExclusiveOptionalModelProperty)modelProperty).isOneRequired());
    }

    private ValueResolver getValueResolverFromMetadataType(String paramName, MetadataType expected, Object value, Object defaultValue, boolean acceptsReferences, Class<?> expectedClass) {
        ValueResolverFactoryTypeVisitor visitor = new ValueResolverFactoryTypeVisitor(paramName, value, defaultValue, acceptsReferences, expectedClass);
        expected.accept((MetadataTypeVisitor)visitor);
        return visitor.getResolver();
    }
}

