/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import jakarta.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;

public class TypeSafeExpressionValueResolver<T>
implements ValueResolver<T>,
Initialisable {
    private final Class<T> expectedType;
    private final String expression;
    private TypeSafeValueResolverWrapper<T> delegate;
    private TransformationService transformationService;
    private ExtendedExpressionManager extendedExpressionManager;
    private final DataType expectedDataType;

    public TypeSafeExpressionValueResolver(String expression, Class<T> expectedType, DataType expectedDataType) {
        Preconditions.checkArgument((expectedType != null ? 1 : 0) != 0, (String)"expected type cannot be null");
        this.expression = expression;
        this.expectedType = expectedType;
        this.expectedDataType = expectedDataType;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        return this.delegate.resolve(context);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    public void initialise() throws InitialisationException {
        ExpressionValueResolver resolver = new ExpressionValueResolver(this.expression, this.expectedDataType);
        resolver.setExtendedExpressionManager(this.extendedExpressionManager);
        resolver.initialise();
        this.delegate = new TypeSafeValueResolverWrapper<T>(resolver, this.expectedType);
        this.delegate.setTransformationService(this.transformationService);
        this.delegate.initialise();
    }

    @Inject
    public void setTransformationService(TransformationService transformationService) {
        this.transformationService = transformationService;
    }

    @Inject
    public void setExtendedExpressionManager(ExtendedExpressionManager extendedExpressionManager) {
        this.extendedExpressionManager = extendedExpressionManager;
    }

    public String toString() {
        return "TypeSafeExpressionValueResolver: " + this.expression;
    }
}

