/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.runtime.exception.RequiredParameterNotSetException;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

final class ValidatingParametersResolver
extends ParametersResolver {
    ValidatingParametersResolver(MuleContext muleContext, Map<String, ?> parameters, ReflectionCache reflectionCache, ExtendedExpressionManager expressionManager, String parameterOwner) {
        super(muleContext, parameters, reflectionCache, expressionManager, parameterOwner);
    }

    @Override
    protected ResolverSet getResolverSet(Optional<ParameterizedModel> model, List<ParameterGroupModel> groups, List<ParameterModel> parameterModels, ResolverSet resolverSet) throws ConfigurationException {
        ResolverSet populatedResolverSet = super.getResolverSet(model, groups, parameterModels, resolverSet);
        Map aliasedParameterNames = SmallMap.forSize((int)parameterModels.size());
        parameterModels.stream().filter(p -> !p.isComponentId() || p.getModelProperty(ExtensionParameterDescriptorModelProperty.class).isPresent()).forEach(p -> {
            String parameterName = IntrospectionUtils.getMemberName((EnrichableModel)p, p.getName());
            if (!parameterName.equals(p.getName())) {
                aliasedParameterNames.put(parameterName, p.getName());
            }
        });
        MuleExtensionUtils.checkParameterGroupExclusiveness(model, groups, this.getParameters(), aliasedParameterNames);
        return populatedResolverSet;
    }

    @Override
    protected void addToResolverSet(ParameterModel paramModel, ResolverSet resolverSet, ValueResolver<?> resolver) {
        if (paramModel.isRequired() && resolver == null) {
            throw new RequiredParameterNotSetException(paramModel);
        }
        super.addToResolverSet(paramModel, resolverSet, resolver);
    }

    @Override
    protected void addPropertyResolver(DefaultObjectBuilder builder, ValueResolver<?> valueResolver, ObjectFieldType field, Field objectField) {
        if (field.isRequired() && !ExtensionMetadataTypeUtils.isFlattenedParameterGroup((MetadataType)field)) {
            throw new RequiredParameterNotSetException(objectField.getName());
        }
        super.addPropertyResolver(builder, valueResolver, field, objectField);
    }
}

