/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.component;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.FieldManifestation;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.core.internal.util.MultiParentClassLoaderUtils;
import org.mule.runtime.module.extension.internal.component.AnnotatedObjectInvocationHandlerInterceptors;
import org.mule.runtime.module.extension.privileged.component.ComponentAdditionalInterceptor;
import org.mule.runtime.module.extension.privileged.component.ComponentInterceptor;
import org.mule.runtime.module.extension.privileged.component.DynamicallyComponent;
import org.mule.runtime.module.extension.privileged.component.DynamicallySerializableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotatedObjectInvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotatedObjectInvocationHandler.class);
    private static final ByteBuddy byteBuddy = new ByteBuddy();
    private static final Set<Method> MANAGED_METHODS = Collections.unmodifiableSet(new HashSet<Method>(Arrays.asList(Component.class.getDeclaredMethods())));
    private static final Method COMPONENT_ADDITIONAL_INTERCEPTOR_CREATE;
    private static final Method COMPONENT_INTERCEPTOR_CREATE;
    private static final String COMPONENT_DELEGATE_FIELD_NAME = "__componentInterceptorDelegate";
    private static final String COMPONENT_ADDITIONAL_DELEGATE_FIELD_NAME = "__componentAdditionalInterceptorDelegate";

    public static <T, A extends Component> Class<A> addAnnotationsToClass(Class<T> clazz) {
        if (clazz.getPackageName().startsWith("java.")) {
            return clazz;
        }
        if (Component.class.isAssignableFrom(clazz) && Arrays.asList(clazz.getMethods()).stream().anyMatch(m -> "getAnnotations".equals(m.getName()) && !m.isDefault())) {
            return clazz;
        }
        if (Modifier.isFinal(clazz.getModifiers())) {
            throw new UnsupportedOperationException("Class '" + clazz.getName() + "' must either not be final or implement '" + Component.class.getName() + "'");
        }
        ClassLoader classLoader = MultiParentClassLoaderUtils.multiParentClassLoaderFor((ClassLoader)clazz.getClassLoader());
        String enhancedClassName = clazz.getName() + "$ByteBuddy$withAnnotations";
        try {
            return classLoader.loadClass(enhancedClassName);
        }
        catch (ClassNotFoundException e) {
            return AnnotatedObjectInvocationHandler.doAddAnnotationsToClass(clazz, classLoader, enhancedClassName);
        }
    }

    private static <T, A extends Component> Class<A> doAddAnnotationsToClass(Class<T> clazz, ClassLoader classLoader, String enhancedClassName) {
        Class<DynamicallyComponent> dynamicInterface;
        if (Serializable.class.isAssignableFrom(clazz)) {
            try {
                clazz.getConstructor(new Class[0]);
                dynamicInterface = DynamicallySerializableComponent.class;
            }
            catch (SecurityException e) {
                throw new UnsupportedOperationException("Class '" + clazz.getName() + "' cannot be enhanced for annotations (" + e.getMessage() + ")", e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("Class '" + clazz.getName() + "' implements Serializable but does not provide a default public constructor. The mechanism to add annotations dynamically requires a default public constructor in a Serializable class.");
                dynamicInterface = DynamicallyComponent.class;
            }
        } else {
            dynamicInterface = DynamicallyComponent.class;
        }
        DynamicType.Builder.MethodDefinition.ImplementationDefinition.Optional builder = byteBuddy.subclass(clazz, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_CLASS).implement(new Type[]{dynamicInterface});
        builder = builder.defineField(COMPONENT_DELEGATE_FIELD_NAME, ComponentInterceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE, FieldManifestation.VOLATILE}).defineField(COMPONENT_ADDITIONAL_DELEGATE_FIELD_NAME, ComponentAdditionalInterceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE, FieldManifestation.VOLATILE});
        for (Method method : MANAGED_METHODS) {
            builder = builder.method((ElementMatcher)ElementMatchers.named((String)method.getName()).and((ElementMatcher)ElementMatchers.takesArguments((Class[])method.getParameterTypes()))).intercept((Implementation)MethodDelegation.toField((String)COMPONENT_DELEGATE_FIELD_NAME));
        }
        builder = builder.name(enhancedClassName).method((ElementMatcher)ElementMatchers.named((String)"writeReplace").or((ElementMatcher)ElementMatchers.isToString().and((ElementMatcher)ElementMatchers.isDeclaredBy(Object.class)))).intercept((Implementation)MethodDelegation.toField((String)COMPONENT_ADDITIONAL_DELEGATE_FIELD_NAME));
        builder = builder.constructor((ElementMatcher)ElementMatchers.any()).intercept((Implementation)SuperMethodCall.INSTANCE.andThen((Implementation.Composable)MethodCall.invoke((Method)COMPONENT_INTERCEPTOR_CREATE).setsField((ElementMatcher)ElementMatchers.named((String)COMPONENT_DELEGATE_FIELD_NAME))).andThen((Implementation.Composable)MethodCall.invoke((Method)COMPONENT_ADDITIONAL_INTERCEPTOR_CREATE).withThis().setsField((ElementMatcher)ElementMatchers.named((String)COMPONENT_ADDITIONAL_DELEGATE_FIELD_NAME))));
        return builder.make().load(classLoader).getLoaded();
    }

    public static <T, A> T removeDynamicAnnotations(A annotated) {
        return AnnotatedObjectInvocationHandlerInterceptors.removeDynamicAnnotations(annotated);
    }

    static {
        try {
            COMPONENT_ADDITIONAL_INTERCEPTOR_CREATE = ComponentAdditionalInterceptor.class.getMethod("create", Component.class);
            COMPONENT_INTERCEPTOR_CREATE = ComponentInterceptor.class.getMethod("create", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

