/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.streaming.StreamingUtils;
import org.mule.runtime.core.privileged.event.EventedResult;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.internal.runtime.operation.ChainExecutor;
import org.mule.runtime.module.extension.internal.runtime.operation.ProcessorChainExecutor;

public class ImmutableProcessorChainExecutor
implements ProcessorChainExecutor {
    private final MessageProcessorChain chain;
    private final CoreEvent originalEvent;
    private final ChainExecutor chainExecutor;

    public ImmutableProcessorChainExecutor(CoreEvent event, MessageProcessorChain chain) {
        this.originalEvent = event;
        this.chain = chain;
        this.chainExecutor = new ChainExecutor(chain, this.originalEvent);
    }

    public void process(Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        this.doProcess(this.originalEvent, onSuccess, onError);
    }

    public void process(Object payload, Object attributes, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        CoreEvent customEvent = CoreEvent.builder((CoreEvent)this.originalEvent).message(Message.builder().payload(StreamingUtils.updateTypedValueWithCursorProvider((TypedValue)TypedValue.of((Object)payload))).attributes(TypedValue.of((Object)attributes)).build()).build();
        this.doProcess(customEvent, onSuccess, onError);
    }

    public void process(Result result, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        if (result instanceof EventedResult) {
            this.doProcess(((EventedResult)result).getEvent(), onSuccess, onError);
        } else {
            this.process(result.getOutput(), result.getAttributes(), onSuccess, onError);
        }
    }

    private void doProcess(CoreEvent event, Consumer<Result> onSuccess, BiConsumer<Throwable, Result> onError) {
        Objects.requireNonNull(onSuccess, "A success completion handler is required in order to execute the components chain, but it was null");
        Objects.requireNonNull(onError, "An error completion handler is required in order to execute the components chain, but it was null");
        this.chainExecutor.execute(event, onSuccess, onError);
    }

    public List<Processor> getMessageProcessors() {
        return this.chain.getMessageProcessors();
    }

    @Override
    public CoreEvent getOriginalEvent() {
        return this.originalEvent;
    }
}

