/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import static org.mule.runtime.core.api.lifecycle.LifecycleUtils.disposeIfNeeded;
import static org.mule.runtime.core.api.lifecycle.LifecycleUtils.initialiseIfNeeded;
import static org.mule.runtime.core.api.lifecycle.LifecycleUtils.startIfNeeded;
import static org.mule.runtime.core.api.lifecycle.LifecycleUtils.stopIfNeeded;

import static org.slf4j.LoggerFactory.getLogger;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;

import org.slf4j.Logger;

public class RouteBuilderValueResolver<T> extends ObjectBuilderValueResolver<T> implements Lifecycle {

  private static final Logger LOGGER = getLogger(RouteBuilderValueResolver.class);

  private MessageProcessorChain nestedChain;

  public RouteBuilderValueResolver(ObjectBuilder<T> builder, Injector injector, MessageProcessorChain chain) {
    super(builder, injector);
    this.nestedChain = chain;
  }

  @Override
  public void initialise() throws InitialisationException {
    super.initialise();
    if (nestedChain != null) {
      initialiseIfNeeded(nestedChain, injector);
    }
  }

  @Override
  public void dispose() {
    if (nestedChain != null) {
      disposeIfNeeded(nestedChain, LOGGER);
    }
  }

  @Override
  public void start() throws MuleException {
    if (nestedChain != null) {
      startIfNeeded(nestedChain);
    }
  }

  @Override
  public void stop() throws MuleException {
    if (nestedChain != null) {
      stopIfNeeded(nestedChain);
    }
  }
}
