/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.loader.parser.ValueProviderFactory;
import org.mule.runtime.extension.api.loader.parser.ValueProviderFactoryContext;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.internal.loader.java.property.InjectableParameterInfo;
import org.mule.runtime.module.extension.internal.util.InjectableParameterResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.value.SdkValueProviderAdapter;
import org.mule.sdk.api.values.ValueProvider;

public class JavaValueProviderFactory
implements ValueProviderFactory {
    @Inject
    private ExpressionManager expressionManager;
    private final Class<?> resolverClass;
    private final List<FieldElement> injectableFields;
    private final FieldElement configField;
    private final FieldElement connectionField;
    private final Map<String, MetadataType> fieldTypesByName;

    public JavaValueProviderFactory(Class<?> resolverClass, List<FieldElement> injectableFields, FieldElement configField, FieldElement connectionField) {
        this.resolverClass = resolverClass;
        this.injectableFields = injectableFields;
        this.configField = configField;
        this.connectionField = connectionField;
        this.fieldTypesByName = injectableFields.stream().collect(Collectors.toMap(NamedObject::getName, fe -> fe.getType().asMetadataType()));
    }

    public org.mule.runtime.extension.api.values.ValueProvider create(ValueProviderFactoryContext context) throws ValueResolvingException {
        Object resolver;
        try {
            resolver = this.resolverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ValueResolvingException("An error occurred trying to create a ValueProvider", "UNKNOWN", (Throwable)e);
        }
        Map<String, InjectableParameterInfo> injectableParameterInfoByFieldName = this.getInjectableParameterInfos(context.getModel().getParameters());
        InjectableParameterResolver injectableParameterResolver = new InjectableParameterResolver(context.getComponentParameterization(), (MuleExpressionLanguage)this.expressionManager, injectableParameterInfoByFieldName.values().stream().toList());
        this.injectValueProviderFields(resolver, injectableParameterResolver, injectableParameterInfoByFieldName);
        if (this.connectionField != null && this.connectionField.getField().isPresent()) {
            Object connection;
            if (context.getConnectionSupplier().isEmpty() || (connection = this.getConnection((Supplier)context.getConnectionSupplier().get())) == null) {
                throw new ValueResolvingException("The value provider requires a connection and none was provided", "MISSING_REQUIRED_PARAMETERS");
            }
            IntrospectionUtils.setValueIntoField(resolver, connection, this.connectionField.getField().get());
        }
        if (this.configField != null && this.configField.getField().isPresent()) {
            Object configuration;
            if (context.getConfigurationSupplier().isEmpty() || (configuration = ((Supplier)context.getConfigurationSupplier().get()).get()) == null) {
                throw new ValueResolvingException("The value provider requires a configuration and none was provided", "MISSING_REQUIRED_PARAMETERS");
            }
            IntrospectionUtils.setValueIntoField(resolver, configuration, this.configField.getField().get());
        }
        return this.adaptResolver(resolver);
    }

    private Object getConnection(Supplier<?> connectionSupplier) throws ValueResolvingException {
        try {
            return connectionSupplier.get();
        }
        catch (Exception e) {
            throw new ValueResolvingException("Failed to establish connection: " + e.getMessage(), "CONNECTION_FAILURE", (Throwable)e);
        }
    }

    public Class<?> getResolverClass() {
        return this.resolverClass;
    }

    public Map<String, MetadataType> getFieldTypesByName() {
        return this.fieldTypesByName;
    }

    private void injectValueProviderFields(Object resolver, InjectableParameterResolver injectableParameterResolver, Map<String, InjectableParameterInfo> injectableParameterInfoByFieldName) throws ValueResolvingException {
        ArrayList<Object> missingParameters = new ArrayList<Object>();
        for (FieldElement injectableField : this.injectableFields) {
            InjectableParameterInfo injectableParameterInfo = injectableParameterInfoByFieldName.get(injectableField.getName());
            if (injectableField.getField().isEmpty()) continue;
            String fieldName = injectableParameterInfo.getParameterName();
            Object parameterValue = injectableParameterResolver.getInjectableParameterValue(fieldName);
            if (parameterValue != null) {
                IntrospectionUtils.setValueIntoField(resolver, parameterValue, injectableField.getField().get());
                continue;
            }
            if (!injectableParameterInfo.isRequired()) continue;
            String extractionExpression = injectableParameterInfo.getExtractionExpression();
            if (fieldName.equals(extractionExpression)) {
                missingParameters.add(fieldName);
                continue;
            }
            missingParameters.add(fieldName + "(taken from: " + extractionExpression + ")");
        }
        if (!missingParameters.isEmpty()) {
            throw new ValueResolvingException("Unable to retrieve values. There are missing required parameters for the resolution: " + String.valueOf(missingParameters), "MISSING_REQUIRED_PARAMETERS");
        }
    }

    private org.mule.runtime.extension.api.values.ValueProvider adaptResolver(Object resolverObject) throws ValueResolvingException {
        if (resolverObject instanceof org.mule.runtime.extension.api.values.ValueProvider) {
            return (org.mule.runtime.extension.api.values.ValueProvider)resolverObject;
        }
        if (resolverObject instanceof ValueProvider) {
            return new SdkValueProviderAdapter((ValueProvider)resolverObject);
        }
        throw new ValueResolvingException(String.format("An error occurred trying to create a ValueProvider: %s should implement %s or %s", resolverObject.getClass().getName(), org.mule.runtime.extension.api.values.ValueProvider.class.getName(), ValueProvider.class.getName()), "UNKNOWN");
    }

    Map<String, InjectableParameterInfo> getInjectableParameterInfos(List<ActingParameterModel> actingParameterModels) {
        LinkedHashMap<String, InjectableParameterInfo> injectableParameterInfos = new LinkedHashMap<String, InjectableParameterInfo>();
        int i = 0;
        for (FieldElement fieldElement : this.injectableFields) {
            injectableParameterInfos.put(fieldElement.getName(), new InjectableParameterInfo(fieldElement.getName(), fieldElement.getType().asMetadataType(), fieldElement.isRequired(), actingParameterModels.get(i++).getExtractionExpression()));
        }
        return injectableParameterInfos;
    }
}

