/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.manager.ConfigurationExpirationMonitor;
import org.mule.runtime.module.extension.internal.manager.ExtensionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultConfigurationExpirationMonitor
implements ConfigurationExpirationMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfigurationExpirationMonitor.class);
    private ExtensionRegistry extensionRegistry;
    private MuleContext muleContext;
    private long frequency;
    private TimeUnit timeUnit;
    private BiConsumer<String, ConfigurationInstance> expirationHandler;
    private Scheduler executor;
    private ScheduledFuture<?> scheduledMonitoring;

    private DefaultConfigurationExpirationMonitor() {
    }

    @Override
    public void beginMonitoring() {
        this.executor = this.muleContext.getSchedulerService().ioScheduler(this.muleContext.getSchedulerBaseConfig().withName("extension.expiration.manager").withShutdownTimeout(30L, TimeUnit.SECONDS));
        this.scheduledMonitoring = this.executor.scheduleWithFixedDelay(() -> this.expire(), this.frequency, this.frequency, this.timeUnit);
    }

    private void expire() {
        if (this.stopChecking()) {
            return;
        }
        LOGGER.debug("Running configuration expiration cycle");
        try {
            MultiMap<String, ConfigurationInstance> expired = this.extensionRegistry.getExpiredConfigs();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(expired.isEmpty() ? "No expired configuration instances were found" : "Found {} expired configurations", (Object)expired.size());
            }
            expired.keySet().stream().forEach(k -> expired.getAll(k).forEach(v -> this.handleExpiration((String)k, (ConfigurationInstance)v)));
        }
        catch (Exception e) {
            LOGGER.error("Found exception trying to expire idle configurations. Will try again on next cycle", (Throwable)e);
        }
    }

    private void handleExpiration(String key, ConfigurationInstance config) {
        if (this.stopChecking()) {
            return;
        }
        try {
            this.expirationHandler.accept(key, config);
            LOGGER.debug("Configuration of key {} was expired", (Object)key);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Could not process expiration for dynamic config '%s' of type '%s'. Will try again on next cycle", key, config.getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public void stopMonitoring() {
        this.scheduledMonitoring.cancel(false);
        this.executor.stop();
    }

    private boolean stopChecking() {
        return this.muleContext.isStopping() || this.muleContext.isStopped();
    }

    public static class Builder {
        private DefaultConfigurationExpirationMonitor manager = new DefaultConfigurationExpirationMonitor();

        public static Builder newBuilder(ExtensionRegistry extensionRegistry, MuleContext muleContext) {
            Builder builder = new Builder();
            builder.manager.extensionRegistry = extensionRegistry;
            builder.manager.muleContext = muleContext;
            return builder;
        }

        private Builder() {
        }

        public Builder runEvery(long frequency, TimeUnit timeUnit) {
            this.manager.frequency = frequency;
            this.manager.timeUnit = timeUnit;
            return this;
        }

        public Builder onExpired(BiConsumer<String, ConfigurationInstance> expirationHandler) {
            this.manager.expirationHandler = expirationHandler;
            return this;
        }

        public ConfigurationExpirationMonitor build() {
            Preconditions.checkArgument((this.manager.extensionRegistry != null ? 1 : 0) != 0, (String)"extensionRegistry cannot be null");
            Preconditions.checkArgument((this.manager.muleContext != null ? 1 : 0) != 0, (String)"muleContext cannot be null");
            Preconditions.checkArgument((this.manager.frequency > 0L ? 1 : 0) != 0, (String)"frequency must be greater than zero");
            Preconditions.checkArgument((this.manager.timeUnit != null ? 1 : 0) != 0, (String)"timeUnit cannot be null");
            return this.manager;
        }
    }
}

