/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.metadata.BaseMetadataDelegate;
import org.mule.runtime.module.extension.internal.metadata.MetadataResolverUtils;

class MetadataOutputDelegate
extends BaseMetadataDelegate {
    MetadataOutputDelegate(EnrichableModel model) {
        super(model);
    }

    Optional<String> getCategoryName() {
        return org.mule.runtime.extension.api.metadata.MetadataResolverUtils.getCategoryName((MetadataResolverFactory)this.resolverFactory);
    }

    MetadataResult<OutputMetadataDescriptor> getOutputMetadataDescriptor(MetadataContext context, Object key) {
        if (!(this.model instanceof HasOutputModel)) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage("The given component has not output definition to be described").onComponent()});
        }
        MetadataResult<MetadataType> output = this.getOutputMetadata(context, key);
        MetadataResult<MetadataType> attributes = this.getOutputAttributesMetadata(context, key);
        HasOutputModel componentWithOutput = (HasOutputModel)this.model;
        MetadataResult<TypeMetadataDescriptor> outputDescriptor = this.toMetadataDescriptorResult(componentWithOutput.getOutput().getType(), componentWithOutput.getOutput().hasDynamicType(), output);
        MetadataResult<TypeMetadataDescriptor> attributesDescriptor = this.toMetadataDescriptorResult(componentWithOutput.getOutputAttributes().getType(), componentWithOutput.getOutputAttributes().hasDynamicType(), attributes);
        OutputMetadataDescriptor descriptor = OutputMetadataDescriptor.builder().withReturnType((TypeMetadataDescriptor)outputDescriptor.get()).withAttributesType((TypeMetadataDescriptor)attributesDescriptor.get()).build();
        if (!output.isSuccess() || !attributes.isSuccess()) {
            ArrayList failures = new ArrayList();
            failures.addAll(output.getFailures());
            failures.addAll(attributes.getFailures());
            return MetadataResult.failure((Object)descriptor, failures);
        }
        return MetadataResult.success((Object)descriptor);
    }

    Optional<NamedTypeResolver> getOutputResolver() {
        return this.getOptionalResolver((NamedTypeResolver)this.resolverFactory.getOutputResolver());
    }

    Optional<NamedTypeResolver> getOutputAttributesResolver() {
        return this.getOptionalResolver((NamedTypeResolver)this.resolverFactory.getOutputAttributesResolver());
    }

    private MetadataResult<MetadataType> getOutputMetadata(MetadataContext context, Object key) {
        OutputModel output = ((HasOutputModel)this.model).getOutput();
        if (MetadataTypeUtils.isVoid((MetadataType)output.getType()) || !output.hasDynamicType()) {
            return MetadataResult.success((Object)output.getType());
        }
        try {
            MetadataType metadata = (MetadataType)MetadataResolverUtils.resolveWithOAuthRefresh(context, () -> this.resolverFactory.getOutputResolver().getOutputType(context, key));
            if (this.isMetadataResolvedCorrectly(metadata, true)) {
                return MetadataResult.success((Object)this.adaptToListIfNecessary(metadata, key, context));
            }
            MetadataFailure failure = MetadataFailure.Builder.newFailure().withMessage("Error resolving Output Payload metadata").withFailureCode(FailureCode.NO_DYNAMIC_TYPE_AVAILABLE).withReason("NullType is not a valid type for this element").onOutputPayload();
            return MetadataResult.failure((Object)output.getType(), (MetadataFailure[])new MetadataFailure[]{failure});
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).withMessage("Failed to establish connection: " + ExceptionUtils.getMessage((Throwable)e)).withFailureCode(FailureCode.CONNECTION_FAILURE).onComponent()});
        }
        catch (Exception e) {
            return MetadataResult.failure((Object)output.getType(), (MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onOutputPayload()});
        }
    }

    private MetadataResult<MetadataType> getOutputAttributesMetadata(MetadataContext context, Object key) {
        OutputModel attributes = ((HasOutputModel)this.model).getOutputAttributes();
        if (MetadataTypeUtils.isVoid((MetadataType)attributes.getType()) || !attributes.hasDynamicType()) {
            return MetadataResult.success((Object)attributes.getType());
        }
        return this.resolveOutputAttributesMetadata(context, key, metadata -> this.isMetadataResolvedCorrectly((MetadataType)metadata, true));
    }

    private MetadataResult<MetadataType> resolveOutputAttributesMetadata(MetadataContext context, Object key, Function<MetadataType, Boolean> metadataValidator) {
        try {
            MetadataType metadata = (MetadataType)MetadataResolverUtils.resolveWithOAuthRefresh(context, () -> this.resolverFactory.getOutputAttributesResolver().getAttributesType(context, key));
            if (metadataValidator.apply(metadata).booleanValue()) {
                return MetadataResult.success((Object)metadata);
            }
            MetadataFailure failure = MetadataFailure.Builder.newFailure().withMessage("Error resolving Output Attributes metadata").withFailureCode(FailureCode.NO_DYNAMIC_TYPE_AVAILABLE).withReason("NullType is not a valid type for this element").onOutputAttributes();
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{failure});
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).withMessage("Failed to establish connection: " + ExceptionUtils.getMessage((Throwable)e)).withFailureCode(FailureCode.CONNECTION_FAILURE).onComponent()});
        }
        catch (Exception e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onOutputAttributes()});
        }
    }

    private MetadataResult<TypeMetadataDescriptor> toMetadataDescriptorResult(MetadataType type, boolean isDynamic, MetadataResult<MetadataType> result) {
        MetadataType resultingType = result.get() == null ? type : (MetadataType)result.get();
        TypeMetadataDescriptor descriptor = TypeMetadataDescriptor.builder().withType(resultingType).dynamic(isDynamic).build();
        return result.isSuccess() ? MetadataResult.success((Object)descriptor) : MetadataResult.failure((Object)descriptor, (List)result.getFailures());
    }

    private MetadataType adaptToListIfNecessary(MetadataType resolvedType, Object key, MetadataContext metadataContext) throws MetadataResolvingException {
        MetadataType componentOutputType = ((HasOutputModel)this.model).getOutput().getType();
        if (!MetadataTypeUtils.isCollection((MetadataType)componentOutputType) || MetadataTypeUtils.isVoid((MetadataType)resolvedType) || MetadataTypeUtils.isNullType((MetadataType)resolvedType)) {
            return resolvedType;
        }
        MetadataType collectionValueType = ((ArrayType)componentOutputType).getType();
        Class<?> collectionType = this.getCollectionType(collectionValueType);
        if (Message.class.equals(collectionType)) {
            MessageMetadataType message = (MessageMetadataType)collectionValueType;
            resolvedType = this.wrapInMessageType(resolvedType, key, metadataContext, message.getAttributesType());
        }
        return metadataContext.getTypeBuilder().arrayType().with((TypeAnnotation)new ClassInformationAnnotation(this.getCollectionType(componentOutputType))).of(resolvedType).build();
    }

    private MetadataType wrapInMessageType(MetadataType type, Object key, MetadataContext context, Optional<MetadataType> staticAttributes) throws MetadataResolvingException {
        MessageMetadataTypeBuilder message = new MessageMetadataTypeBuilder().payload(type);
        staticAttributes.ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)message).attributes(arg_0));
        if (((HasOutputModel)this.model).getOutputAttributes().hasDynamicType()) {
            MetadataResult<MetadataType> attributes = this.resolveOutputAttributesMetadata(context, key, Objects::nonNull);
            if (!attributes.isSuccess()) {
                throw new MetadataResolvingException("Could not resolve attributes of List<Message> output", attributes.getFailures().stream().map(MetadataFailure::getFailureCode).findFirst().orElse(FailureCode.UNKNOWN));
            }
            message.attributes((MetadataType)attributes.get());
        }
        return message.build();
    }

    private Class<?> getCollectionType(MetadataType type) {
        Class clazz = (Class)ExtensionMetadataTypeUtils.getType((MetadataType)type).orElseThrow(() -> new IllegalArgumentException("MetadataType has no class information"));
        if (PagingProvider.class.equals((Object)clazz)) {
            return Iterator.class;
        }
        return clazz;
    }
}

