/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.test;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterModelParserDecorator;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaDeclaredParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.sdk.api.annotation.Configuration;
import org.mule.sdk.api.annotation.Configurations;
import org.mule.sdk.api.annotation.Extension;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.param.ParameterGroup;

public class JavaDeclaredParameterGroupModelParserTestCase {
    @Test
    public void getExclusiveOptionalDescriptorFromExtensionUsingSdkApi() {
        JavaDeclaredParameterGroupModelParser javaDeclaredParameterGroupModelParser = this.getParser(SimpleLegacyExtension.class);
        ParameterGroupModelParser.ExclusiveOptionalDescriptor exclusiveOptionalDescriptor = (ParameterGroupModelParser.ExclusiveOptionalDescriptor)javaDeclaredParameterGroupModelParser.getExclusiveOptionals().get();
        MatcherAssert.assertThat((Object)exclusiveOptionalDescriptor.isOneRequired(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)exclusiveOptionalDescriptor.getExclusiveOptionals().size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)exclusiveOptionalDescriptor.getExclusiveOptionals(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"parameter1", "parameter2"}));
    }

    @Test
    public void getExclusiveOptionalDescriptorFromExtensionUsingLegacyApi() {
        JavaDeclaredParameterGroupModelParser javaDeclaredParameterGroupModelParser = this.getParser(SimpleSdkExtension.class);
        ParameterGroupModelParser.ExclusiveOptionalDescriptor exclusiveOptionalDescriptor = (ParameterGroupModelParser.ExclusiveOptionalDescriptor)javaDeclaredParameterGroupModelParser.getExclusiveOptionals().get();
        MatcherAssert.assertThat((Object)exclusiveOptionalDescriptor.isOneRequired(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)exclusiveOptionalDescriptor.getExclusiveOptionals().size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)exclusiveOptionalDescriptor.getExclusiveOptionals(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"parameter1", "parameter2"}));
    }

    private JavaDeclaredParameterGroupModelParser getParser(Class<?> extension) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        DefaultExtensionLoadingContext ctx = new DefaultExtensionLoadingContext(contextClassLoader, DslResolvingContext.getDefault(Collections.emptySet()));
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(contextClassLoader);
        ExtensionTypeWrapper extensionElement = new ExtensionTypeWrapper(extension, typeLoader);
        ConfigurationElement configurationElement = (ConfigurationElement)extensionElement.getConfigurations().get(0);
        ExtensionParameter extensionParameter = (ExtensionParameter)configurationElement.getParameters().get(0);
        return new JavaDeclaredParameterGroupModelParser(extensionParameter, ParameterDeclarationContext.forConfig((String)"config", (ExtensionLoadingContext)ctx), ParameterModelParserDecorator::new);
    }

    @Extension(name="SimpleLegacyExtension")
    @Configurations(value={SimpleLegacyConfiguration.class})
    private static class SimpleLegacyExtension {
        private SimpleLegacyExtension() {
        }
    }

    @Extension(name="SimpleSdkExtension")
    @Configurations(value={SimpleSdkConfiguration.class})
    private static class SimpleSdkExtension {
        private SimpleSdkExtension() {
        }
    }

    @ExclusiveOptionals(isOneRequired=true)
    private static class PojoWithLegacyExclusiveOptional {
        @org.mule.runtime.extension.api.annotation.param.Parameter
        @org.mule.runtime.extension.api.annotation.param.Optional
        Object parameter1;
        @org.mule.runtime.extension.api.annotation.param.Parameter
        @org.mule.runtime.extension.api.annotation.param.Optional
        Object parameter2;

        private PojoWithLegacyExclusiveOptional() {
        }
    }

    @org.mule.runtime.extension.api.annotation.Configuration(name="oldLegacyConfiguration")
    private static class SimpleLegacyConfiguration {
        @org.mule.runtime.extension.api.annotation.param.ParameterGroup(name="A nice parameter group")
        PojoWithLegacyExclusiveOptional pojoWithLegacyExclusiveOptional;

        private SimpleLegacyConfiguration() {
        }
    }

    @org.mule.sdk.api.annotation.param.ExclusiveOptionals(isOneRequired=true)
    private static class PojoWithSdkExclusiveOptional {
        @Parameter
        @Optional
        Object parameter1;
        @Parameter
        @Optional
        Object parameter2;

        private PojoWithSdkExclusiveOptional() {
        }
    }

    @Configuration(name="newSdkConfiguration")
    private static class SimpleSdkConfiguration {
        @ParameterGroup(name="A nice parameter group")
        PojoWithSdkExclusiveOptional pojoWithSdkExclusiveOptional;

        private SimpleSdkConfiguration() {
        }
    }
}

