/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validator;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class JavaConnectionProviderModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel extensionModel, ProblemsReporter problemsReporter) {
        final HashSet<ConnectionProviderModel> globalConnectionProviders = new HashSet<ConnectionProviderModel>();
        final MultiMap configLevelConnectionProviders = new MultiMap();
        new ExtensionWalker(){

            public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                if (owner instanceof ConfigurationModel) {
                    configLevelConnectionProviders.put((Object)((ConfigurationModel)owner), (Object)model);
                } else {
                    globalConnectionProviders.add(model);
                }
            }
        }.walk(extensionModel);
        this.validateGlobalConnectionTypes(extensionModel, globalConnectionProviders, problemsReporter);
        this.validateConfigLevelConnectionTypes((MultiMap<ConfigurationModel, ConnectionProviderModel>)configLevelConnectionProviders, problemsReporter);
    }

    private void validateGlobalConnectionTypes(ExtensionModel extensionModel, Set<ConnectionProviderModel> globalConnectionProviders, final ProblemsReporter problemsReporter) {
        if (globalConnectionProviders.isEmpty()) {
            return;
        }
        for (final ConnectionProviderModel connectionProviderModel : globalConnectionProviders) {
            final Type connectionType = MuleExtensionUtils.getConnectionType(connectionProviderModel);
            new IdempotentExtensionWalker(){

                protected void onOperation(OperationModel operationModel) {
                    JavaConnectionProviderModelValidator.this.validateConnectionTypes(connectionProviderModel, (ComponentModel)operationModel, connectionType, problemsReporter);
                }

                protected void onSource(SourceModel sourceModel) {
                    JavaConnectionProviderModelValidator.this.validateConnectionTypes(connectionProviderModel, (ComponentModel)sourceModel, connectionType, problemsReporter);
                }
            }.walk(extensionModel);
        }
    }

    private void validateConfigLevelConnectionTypes(MultiMap<ConfigurationModel, ConnectionProviderModel> configLevelConnectionProviders, ProblemsReporter problemsReporter) {
        configLevelConnectionProviders.keySet().forEach(configModel -> {
            for (ConnectionProviderModel providerModel : configLevelConnectionProviders.getAll(configModel)) {
                if (MuleExtensionUtils.isSynthetic((EnrichableModel)providerModel)) continue;
                Type connectionType = MuleExtensionUtils.getConnectionType(providerModel);
                configModel.getOperationModels().forEach(operationModel -> this.validateConnectionTypes(providerModel, (ComponentModel)operationModel, connectionType, problemsReporter));
            }
        });
    }

    private <T> Optional<Type> getConnectionType(EnrichableModel model) {
        Optional<ConnectivityModelProperty> connectivityProperty = model.getModelProperty(ConnectivityModelProperty.class);
        if (!connectivityProperty.isPresent() && model instanceof ParameterizedModel) {
            connectivityProperty = ((ParameterizedModel)model).getAllParameterModels().stream().map(p -> p.getModelProperty(ConnectivityModelProperty.class).orElse(null)).filter(Objects::nonNull).findFirst();
        }
        return connectivityProperty.map(ConnectivityModelProperty::getConnectionType);
    }

    private void validateConnectionTypes(ConnectionProviderModel providerModel, ComponentModel componentModel, Type providerConnectionType, ProblemsReporter problemsReporter) {
        this.getConnectionType((EnrichableModel)componentModel).ifPresent(connectionType -> {
            if (!connectionType.isAssignableFrom(providerConnectionType)) {
                problemsReporter.addError(new Problem((NamedObject)providerModel, String.format("Component '%s' requires a connection of type '%s'. However, it also defines connection provider '%s' which yields connections of incompatible type '%s'", componentModel.getName(), connectionType.getName(), providerModel.getName(), providerConnectionType.getName())));
            }
        });
    }
}

