/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.util.mediatype.MediaTypeDecoratedResultCollection;
import org.mule.runtime.core.internal.util.mediatype.MediaTypeDecoratedResultIterator;
import org.mule.runtime.core.internal.util.mediatype.PayloadMediaTypeResolver;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.CollectionReturnHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.MapReturnHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.ReturnHandler;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

abstract class AbstractReturnDelegate
implements ReturnDelegate {
    protected final MuleContext muleContext;
    private boolean returnsListOfMessages = false;
    private final CursorProviderFactory cursorProviderFactory;
    private final MediaType defaultMediaType;
    private boolean isSpecialHandling = false;
    private ReturnHandler returnHandler = ReturnHandler.nullHandler();
    private Charset defaultEncoding;

    protected AbstractReturnDelegate(ComponentModel componentModel, CursorProviderFactory cursorProviderFactory, MuleContext muleContext) {
        if (componentModel instanceof HasOutputModel) {
            HasOutputModel hasOutputModel = (HasOutputModel)componentModel;
            this.returnsListOfMessages = MuleExtensionUtils.returnsListOfMessages(hasOutputModel);
            MetadataType outputType = hasOutputModel.getOutput().getType();
            if (ExtensionMetadataTypeUtils.isMap((MetadataType)outputType)) {
                this.isSpecialHandling = true;
                this.returnHandler = new MapReturnHandler(hasOutputModel);
            } else if (ExtensionMetadataTypeUtils.isJavaCollection((MetadataType)outputType)) {
                this.isSpecialHandling = true;
                this.returnHandler = new CollectionReturnHandler(outputType);
            }
        }
        this.muleContext = muleContext;
        this.cursorProviderFactory = cursorProviderFactory;
        this.defaultEncoding = SystemUtils.getDefaultEncoding((MuleContext)muleContext);
        this.defaultMediaType = org.mule.runtime.module.extension.internal.util.MediaTypeUtils.getDefaultMediaType(componentModel);
    }

    protected Message toMessage(Object value, ExecutionContextAdapter operationContext) {
        if (value instanceof Event) {
            return ((Event)value).getMessage();
        }
        Map params = operationContext.getParameters();
        Optional<MediaType> contextMimeTypeParam = this.getContextMimeType(params);
        Optional<Charset> contextEncodingParam = this.getContextEncoding(params);
        MediaType mediaType = this.resolveMediaType(value, contextMimeTypeParam, contextEncodingParam);
        CoreEvent event = operationContext.getEvent();
        ComponentLocation originatingLocation = operationContext.getComponent().getLocation();
        if (value instanceof Result) {
            ConnectionHandler connectionHandler;
            Result resultValue = (Result)value;
            if (resultValue.getOutput() instanceof InputStream && (connectionHandler = (ConnectionHandler)operationContext.getVariable("MULE_CONNECTION_PARAM")) != null && StreamingUtils.supportsStreaming((ComponentModel)operationContext.getComponentModel())) {
                resultValue = resultValue.copy().output((Object)new ConnectedInputStreamWrapper((InputStream)resultValue.getOutput(), connectionHandler)).build();
            }
            return this.isSpecialHandling && this.returnHandler.handles(resultValue.getOutput()) ? MessageUtils.toMessage((Result)resultValue, (MediaType)mediaType, (CursorProviderFactory)this.cursorProviderFactory, (CoreEvent)event, (DataType)this.returnHandler.getDataType(), (ComponentLocation)originatingLocation) : MessageUtils.toMessage((Result)resultValue, (MediaType)mediaType, (CursorProviderFactory)this.cursorProviderFactory, (CoreEvent)event, (ComponentLocation)originatingLocation);
        }
        PayloadMediaTypeResolver payloadMediaTypeResolver = new PayloadMediaTypeResolver(SystemUtils.getDefaultEncoding((MuleContext)this.muleContext), this.defaultMediaType, contextEncodingParam, contextMimeTypeParam);
        if (value instanceof Collection && this.returnsListOfMessages) {
            value = this.toLazyMessageCollection((Collection)value, operationContext, this.cursorProviderFactory, mediaType, event);
            value = MessageUtils.toMessageCollection((Collection)new MediaTypeDecoratedResultCollection((Collection)value, payloadMediaTypeResolver), (CursorProviderFactory)this.cursorProviderFactory, (BaseEventContext)((BaseEventContext)event.getContext()).getRootContext(), (ComponentLocation)originatingLocation);
        } else if (value instanceof Iterator && this.returnsListOfMessages) {
            value = MessageUtils.toMessageIterator((Iterator)new MediaTypeDecoratedResultIterator((Iterator)value, payloadMediaTypeResolver), (CursorProviderFactory)this.cursorProviderFactory, (BaseEventContext)((BaseEventContext)event.getContext()).getRootContext(), (ComponentLocation)originatingLocation);
        }
        value = this.streamingContent(value, operationContext, this.cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext(), originatingLocation);
        Object messageBuilder = this.returnsListOfMessages && value instanceof Collection ? Message.builder().collectionValue((Collection)value, Message.class) : (this.isSpecialHandling && this.returnHandler.handles(value) ? this.returnHandler.toMessageBuilder(value) : Message.builder().value(value));
        return messageBuilder.mediaType(mediaType).build();
    }

    private Collection<Object> toLazyMessageCollection(Collection<Result> values, ExecutionContextAdapter operationContext, CursorProviderFactory cursorProviderFactory, MediaType mediaType, CoreEvent event) {
        ArrayList<Object> lazyMessageCollection = new ArrayList<Object>();
        values.forEach(value -> {
            if (value.getOutput() instanceof InputStream) {
                ConnectionHandler connectionHandler = (ConnectionHandler)operationContext.getVariable("MULE_CONNECTION_PARAM");
                if (connectionHandler != null && StreamingUtils.supportsStreaming((ComponentModel)operationContext.getComponentModel())) {
                    value = value.copy().output((Object)new ConnectedInputStreamWrapper((InputStream)value.getOutput(), connectionHandler)).build();
                }
                Message message = MessageUtils.toMessage((Result)value, (MediaType)mediaType, (CursorProviderFactory)cursorProviderFactory, (CoreEvent)event, (ComponentLocation)operationContext.getComponent().getLocation());
                lazyMessageCollection.add(message);
            } else {
                lazyMessageCollection.add(value);
            }
        });
        return lazyMessageCollection;
    }

    private Optional<MediaType> getContextMimeType(Map<String, Object> params) {
        return Optional.ofNullable((String)params.get("outputMimeType")).map(mimeType -> MediaType.parseDefinedInApp((String)mimeType));
    }

    private Optional<Charset> getContextEncoding(Map<String, Object> params) {
        return Optional.ofNullable((String)params.get("outputEncoding")).map(encoding -> MediaTypeUtils.parseCharset((String)encoding));
    }

    private Object streamingContent(Object value, ExecutionContextAdapter operationContext, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext, ComponentLocation originatingLocation) {
        ConnectionHandler connectionHandler;
        if (value instanceof InputStream && (connectionHandler = (ConnectionHandler)operationContext.getVariable("MULE_CONNECTION_PARAM")) != null && StreamingUtils.supportsStreaming((ComponentModel)operationContext.getComponentModel())) {
            value = new ConnectedInputStreamWrapper((InputStream)value, connectionHandler);
        }
        return StreamingUtils.streamingContent((Object)value, (CursorProviderFactory)cursorProviderFactory, (EventContext)eventContext, (ComponentLocation)originatingLocation);
    }

    protected MediaType resolveMediaType(Object value, Optional<MediaType> contextMimeType, Optional<Charset> contextEncoding) {
        Optional optionalMediaType;
        Charset existingEncoding = this.defaultEncoding;
        MediaType mediaType = this.defaultMediaType;
        if (value instanceof Result && (optionalMediaType = ((Result)value).getMediaType()).isPresent() && (mediaType = (MediaType)optionalMediaType.get()).getCharset().isPresent()) {
            existingEncoding = mediaType.getCharset().orElse(existingEncoding);
        }
        return contextMimeType.orElse(mediaType).withCharset(contextEncoding.orElse(existingEncoding));
    }

    protected class ConnectedInputStreamWrapper
    extends InputStream {
        private final InputStream delegate;
        private final ConnectionHandler<?> connectionHandler;

        private ConnectedInputStreamWrapper(InputStream delegate, ConnectionHandler<?> connectionHandler) {
            this.delegate = delegate;
            this.connectionHandler = connectionHandler;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                this.connectionHandler.release();
            }
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

