/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ObjectBuilderValueResolver<T>
extends AbstractComponent
implements ValueResolver<T>,
Initialisable,
ParameterValueResolver {
    private final ObjectBuilder<T> builder;
    private final MuleContext muleContext;

    public ObjectBuilderValueResolver(ObjectBuilder<T> builder, MuleContext muleContext) {
        Preconditions.checkArgument((builder != null ? 1 : 0) != 0, (String)"builder cannot be null");
        this.builder = builder;
        this.muleContext = muleContext;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        return this.builder.build(context);
    }

    @Override
    public boolean isDynamic() {
        return this.builder.isDynamic();
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.builder, (boolean)true, (MuleContext)this.muleContext);
    }

    @Override
    public Object getParameterValue(String parameterName) throws ValueResolvingException {
        if (this.builder instanceof ParameterValueResolver) {
            return ((ParameterValueResolver)((Object)this.builder)).getParameterValue(parameterName);
        }
        throw new ValueResolvingException(String.format("Unable to resolve value for parameter '%s'", parameterName));
    }
}

