/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.extension.api.annotation.metadata.RequiredForMetadata;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.enricher.RequiredForMetadataDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class RequiredForMetadataDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    private static final String REQUIRED_PARAM = "RequiredParam";
    private static final RequiredForMetadataDeclarationEnricher ENRICHER = new RequiredForMetadataDeclarationEnricher();
    @Mock
    ExtensionDeclaration declaration;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    ExtensionLoadingContext loadingContext;
    @Mock
    ConnectionProviderDeclaration connectionProviderDeclaration;
    @Mock
    ConfigurationDeclaration configurationDeclaration;
    @Mock
    ParameterDeclaration parameterDeclaration;
    @Mock
    ExtensionParameter extensionParameter;
    private ArgumentCaptor<RequiredForMetadataModelProperty> argumentCaptor = ArgumentCaptor.forClass(RequiredForMetadataModelProperty.class);

    @Before
    public void setUp() {
        Mockito.when((Object)this.loadingContext.getExtensionDeclarer().getDeclaration()).thenReturn((Object)this.declaration);
        Mockito.when((Object)this.declaration.getConnectionProviders()).thenReturn(Collections.singletonList(this.connectionProviderDeclaration));
        Mockito.when((Object)this.declaration.getConfigurations()).thenReturn(Collections.singletonList(this.configurationDeclaration));
        ExtensionParameterDescriptorModelProperty descriptorModelProperty = (ExtensionParameterDescriptorModelProperty)Mockito.mock(ExtensionParameterDescriptorModelProperty.class);
        Mockito.when((Object)this.parameterDeclaration.getModelProperty(ExtensionParameterDescriptorModelProperty.class)).thenReturn(Optional.of(descriptorModelProperty));
        Mockito.when((Object)this.parameterDeclaration.getName()).thenReturn((Object)REQUIRED_PARAM);
        Mockito.when((Object)descriptorModelProperty.getExtensionParameter()).thenReturn((Object)this.extensionParameter);
    }

    @Test
    public void connectionProviderWithRequiredForMetadataParameterGetsEnriched() {
        this.enrichDeclaration((ParameterizedDeclaration)this.connectionProviderDeclaration, true);
        ((ConnectionProviderDeclaration)Mockito.verify((Object)this.connectionProviderDeclaration)).addModelProperty((ModelProperty)this.argumentCaptor.capture());
        RequiredForMetadataModelProperty value = (RequiredForMetadataModelProperty)this.argumentCaptor.getValue();
        MatcherAssert.assertThat((Object)value.getRequiredParameters(), (Matcher)CoreMatchers.is((Matcher)IsCollectionContaining.hasItem((Object)REQUIRED_PARAM)));
    }

    @Test
    public void connectionWithOutRequiredForMetadataParameterDontGetsEnriched() {
        this.enrichDeclaration((ParameterizedDeclaration)this.connectionProviderDeclaration, false);
        ((ConnectionProviderDeclaration)Mockito.verify((Object)this.connectionProviderDeclaration, (VerificationMode)Mockito.never())).addModelProperty((ModelProperty)ArgumentMatchers.any(RequiredForMetadataModelProperty.class));
    }

    @Test
    public void configWithRequiredForMetadataParameterGetsEnriched() {
        this.enrichDeclaration((ParameterizedDeclaration)this.configurationDeclaration, true);
        ((ConfigurationDeclaration)Mockito.verify((Object)this.configurationDeclaration)).addModelProperty((ModelProperty)this.argumentCaptor.capture());
        RequiredForMetadataModelProperty value = (RequiredForMetadataModelProperty)this.argumentCaptor.getValue();
        MatcherAssert.assertThat((Object)value.getRequiredParameters(), (Matcher)CoreMatchers.is((Matcher)IsCollectionContaining.hasItem((Object)REQUIRED_PARAM)));
    }

    @Test
    public void configWithOutRequiredForMetadataParameterDontGetsEnriched() {
        this.enrichDeclaration((ParameterizedDeclaration)this.configurationDeclaration, false);
        ((ConfigurationDeclaration)Mockito.verify((Object)this.configurationDeclaration, (VerificationMode)Mockito.never())).addModelProperty((ModelProperty)ArgumentMatchers.any(RequiredForMetadataModelProperty.class));
    }

    private void enrichDeclaration(ParameterizedDeclaration declaration, boolean requiredParameter) {
        Mockito.when((Object)this.extensionParameter.isAnnotatedWith(RequiredForMetadata.class)).thenReturn((Object)requiredParameter);
        ArrayList<ParameterDeclaration> params = new ArrayList<ParameterDeclaration>();
        params.add(this.parameterDeclaration);
        Mockito.when((Object)declaration.getAllParameters()).thenReturn(params);
        ENRICHER.enrich(this.loadingContext);
    }
}

