/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.Typed;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.test.metadata.extension.MetadataExtension;

public class ExtensionWithCustomStaticTypesTestCase
extends AbstractMuleTestCase {
    ExtensionModel extension = MuleExtensionUtils.loadExtension(MetadataExtension.class);

    @Test
    public void withInputXmlStaticType() throws Exception {
        OperationModel o = this.getOperation("xmlInput");
        ParameterModel param = (ParameterModel)o.getAllParameterModels().get(0);
        this.assertXmlOrder((Typed)param);
    }

    @Test
    public void withOutputXmlStaticType() throws Exception {
        OperationModel o = this.getOperation("xmlOutput");
        this.assertXmlOrder((Typed)o.getOutput());
    }

    @Test
    public void withOutputAttributesXmlStaticType() throws Exception {
        OperationModel o = this.getOperation("xmlAttributes");
        this.assertXmlOrder((Typed)o.getOutputAttributes());
    }

    @Test
    public void withInputJsonType() throws Exception {
        OperationModel o = this.getOperation("jsonInputStream");
        ParameterModel param = (ParameterModel)o.getAllParameterModels().get(0);
        this.assertJsonPerson((Typed)param);
    }

    @Test
    public void withOutputJsonType() throws Exception {
        OperationModel o = this.getOperation("jsonOutput");
        this.assertJsonPerson((Typed)o.getOutput());
    }

    @Test
    public void withOutputAttributesJsonType() throws Exception {
        OperationModel o = this.getOperation("jsonAttributes");
        this.assertJsonPerson((Typed)o.getOutputAttributes());
    }

    @Test
    public void customTypeOutput() throws Exception {
        OperationModel o = this.getOperation("customTypeOutput");
        OutputModel output = o.getOutput();
        MetadataType type = output.getType();
        MatcherAssert.assertThat((Object)output.hasDynamicType(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)type.getMetadataFormat(), (Matcher)CoreMatchers.is((Object)MetadataFormat.CSV));
        MatcherAssert.assertThat((Object)type.toString(), (Matcher)CoreMatchers.is((Object)"csv-object"));
    }

    @Test
    public void customTypeInput() throws Exception {
        OperationModel o = this.getOperation("customTypeInput");
        ParameterModel param = (ParameterModel)o.getAllParameterModels().get(0);
        this.assertCustomJsonType((Typed)param);
    }

    @Test
    public void customTypeAttributes() throws Exception {
        OperationModel o = this.getOperation("customAttributesOutput");
        this.assertCustomJsonType((Typed)o.getOutputAttributes());
    }

    @Test
    public void customTypeInputAndOutput() throws Exception {
        OperationModel o = this.getOperation("customInputAndOutput");
        this.assertCustomJsonType((Typed)o.getAllParameterModels().get(0));
        this.assertCustomJavaType((Typed)o.getOutput());
    }

    @Test
    public void customTypeOutputWithStaticAttributes() throws Exception {
        OperationModel o = this.getOperation("customTypeOutputWithStaticAttributes");
        this.assertJsonPerson((Typed)o.getOutput());
        MatcherAssert.assertThat(MetadataTypeUtils.getTypeId((MetadataType)o.getOutputAttributes().getType()).get(), (Matcher)CoreMatchers.is((Object)Banana.class.getName()));
    }

    @Test
    public void sourceXmlOutput() {
        SourceModel s = this.getSource("xml-static-metadata");
        this.assertXmlOrder((Typed)s.getOutput());
        this.assertXmlOrder((Typed)s.getOutputAttributes());
    }

    @Test
    public void sourceCustomOutput() {
        SourceModel s = this.getSource("custom-static-metadata");
        this.assertCustomJavaType((Typed)s.getOutput());
    }

    @Test
    public void sourceOnErrorCustomType() {
        SourceModel s = this.getSource("custom-static-metadata");
        this.assertJsonPerson((Typed)((SourceCallbackModel)s.getErrorCallback().get()).getAllParameterModels().get(0));
    }

    @Test
    public void sourceOnSuccessCustomType() {
        SourceModel s = this.getSource("custom-static-metadata");
        this.assertXmlOrder((Typed)((SourceCallbackModel)s.getSuccessCallback().get()).getAllParameterModels().get(0));
    }

    private SourceModel getSource(String name) {
        return (SourceModel)this.extension.getSourceModel(name).orElseThrow(() -> new RuntimeException("Source Not found"));
    }

    private void assertCustomJavaType(Typed t) {
        MatcherAssert.assertThat((Object)t.hasDynamicType(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)t.getType().getMetadataFormat(), (Matcher)CoreMatchers.is((Object)MetadataFormat.JAVA));
        MatcherAssert.assertThat((Object)((TypeIdAnnotation)t.getType().getAnnotation(TypeIdAnnotation.class).get()).getValue(), (Matcher)CoreMatchers.is((Object)"custom-java"));
        MatcherAssert.assertThat((Object)t.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ObjectType.class)));
    }

    private void assertXmlOrder(Typed typed) {
        MetadataType type = typed.getType();
        MatcherAssert.assertThat((Object)typed.hasDynamicType(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)type.getMetadataFormat(), (Matcher)CoreMatchers.is((Object)MetadataFormat.XML));
        MatcherAssert.assertThat((Object)type.toString(), (Matcher)CoreMatchers.is((Object)"#root:shiporder"));
    }

    private void assertJsonPerson(Typed typed) {
        MetadataType type = typed.getType();
        MatcherAssert.assertThat((Object)typed.hasDynamicType(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)type.getMetadataFormat(), (Matcher)CoreMatchers.is((Object)MetadataFormat.JSON));
        MatcherAssert.assertThat((Object)type, (Matcher)CoreMatchers.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)((ObjectType)type).getFields(), (Matcher)Matchers.hasSize((int)3));
    }

    private OperationModel getOperation(String ope) {
        return (OperationModel)this.extension.getOperationModel(ope).orElseThrow(() -> new RuntimeException(ope + " not found"));
    }

    private void assertCustomJsonType(Typed typed) {
        MetadataType type = typed.getType();
        MatcherAssert.assertThat((Object)typed.hasDynamicType(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)type.getMetadataFormat(), (Matcher)CoreMatchers.is((Object)MetadataFormat.JSON));
        MatcherAssert.assertThat((Object)type.toString(), (Matcher)CoreMatchers.is((Object)"json-object"));
    }
}

