/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.validation.InputParametersTypeModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class InputParameterTypesValidatorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    private ExtensionModel extensionModel;
    @Mock(lenient=true)
    private OperationModel operationModel;
    @Mock(lenient=true)
    private SourceModel sourceModel;
    @Mock(lenient=true)
    private SourceCallbackModel sourceCallbackModel;
    @Mock(lenient=true)
    private ParameterModel invalidParameterModel;
    @Mock(lenient=true)
    private OutputModel outputModel;
    private InputParametersTypeModelValidator validator = new InputParametersTypeModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"dummyExtension");
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Arrays.asList(this.sourceModel));
        Mockito.when((Object)this.extensionModel.getSubTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.extensionModel.getModelProperty(ImplementingTypeModelProperty.class)).thenReturn(Optional.of(new ImplementingTypeModelProperty(Object.class)));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"dummyOperation");
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(Void.TYPE));
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)"dummySource");
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.of(this.sourceCallbackModel));
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.of(this.sourceCallbackModel));
        Mockito.when((Object)this.sourceModel.getTerminateCallback()).thenReturn(Optional.of(this.sourceCallbackModel));
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel, this.sourceModel});
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidModelDueToOperationWithArgumentParameterWithoutGetter() {
        this.validateOperationParameterOfType(ExtensionsTestUtils.toMetadataType(PojoWithParameterWithoutGetter.class));
    }

    @Test
    public void validModelDueToOperationWithArgumentParameterWithGetter() {
        this.validateOperationParameterOfType(ExtensionsTestUtils.toMetadataType(PojoWithParameterWithGetter.class));
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidModelDueToOperationArgumentWithSubtypeWithoutGetter() {
        this.validateOperationParameterOfType(ExtensionsTestUtils.toMetadataType(BaseType.class));
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidModelDueToOperationArgumentWithListOfSubtypeWithoutGetter() {
        this.validateOperationParameterOfType(ExtensionsTestUtils.TYPE_LOADER.load(new TypeToken<List<BaseType>>(){}.getType()));
    }

    private void validateOperationParameterOfType(MetadataType operationParameterType) {
        Mockito.when((Object)this.invalidParameterModel.getType()).thenReturn((Object)operationParameterType);
        Mockito.when((Object)this.invalidParameterModel.getName()).thenReturn((Object)"pojos");
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.invalidParameterModel));
        SubTypesModel subTypesModel = new SubTypesModel(ExtensionsTestUtils.toMetadataType(BaseType.class), (Set)ImmutableSet.of((Object)ExtensionsTestUtils.toMetadataType(PojoWithParameterWithoutGetter.class), (Object)ExtensionsTestUtils.toMetadataType(PojoWithParameterWithGetter.class)));
        Mockito.when((Object)this.extensionModel.getSubTypes()).thenReturn((Object)ImmutableSet.of((Object)subTypesModel));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void validModelDueSubtypeWithoutGetterNotUsedAsInputParameter() {
        SubTypesModel subTypesModel = new SubTypesModel(ExtensionsTestUtils.toMetadataType(BaseType.class), (Set)ImmutableSet.of((Object)ExtensionsTestUtils.toMetadataType(PojoWithParameterWithoutGetter.class)));
        Mockito.when((Object)this.extensionModel.getSubTypes()).thenReturn((Object)ImmutableSet.of((Object)subTypesModel));
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.emptyList());
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void operationOutputIsNotValidated() {
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(PojoWithParameterWithoutGetter.class));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void sourceOutputIsNotValidated() {
        Mockito.when((Object)this.sourceModel.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(PojoWithParameterWithoutGetter.class));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void operationAttributesAreNotValidated() {
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(PojoWithParameterWithoutGetter.class));
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.operationModel.getOutputAttributes()).thenReturn((Object)this.outputModel);
    }

    private static class BaseType {
        @Parameter
        private String baseFieldWithGetter;

        private BaseType() {
        }

        public String getBaseFieldWithGetter() {
            return this.baseFieldWithGetter;
        }
    }

    private static class PojoWithParameterWithGetter
    extends BaseType {
        @Parameter
        private String fieldWithGetter;

        private PojoWithParameterWithGetter() {
        }

        public String getFieldWithGetter() {
            return this.fieldWithGetter;
        }
    }

    private static class PojoWithParameterWithoutGetter
    extends BaseType {
        @Parameter
        private String fieldWithoutGetter;

        private PojoWithParameterWithoutGetter() {
        }
    }
}

