/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity;

import java.util.Optional;
import javax.inject.Inject;
import javax.transaction.TransactionManager;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.privileged.transaction.XaTransaction;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionContextConfigurationDecorator;
import org.mule.runtime.module.extension.internal.runtime.transaction.XAExtensionTransactionalResource;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ExtensionConnectionSupplierTestCase
extends AbstractMuleContextTestCase {
    @Inject
    private ExtensionConnectionSupplier adapter;
    @Inject
    private ConnectionManager connectionManager;
    private XaTransaction transaction;
    private Object config;
    private ExecutionContextAdapter operationContext;
    private ConnectionProvider connectionProvider;
    private ConfigurationInstance configurationInstance;

    protected boolean doTestClassInjection() {
        return true;
    }

    @Before
    public void before() throws Exception {
        muleContext.setTransactionManager((TransactionManager)Mockito.mock(TransactionManager.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        this.transaction = (XaTransaction)Mockito.spy((Object)new XaTransaction(muleContext));
        XATransactionalConnection connection = (XATransactionalConnection)Mockito.mock(XATransactionalConnection.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.config = new Object();
        this.operationContext = (ExecutionContextAdapter)Mockito.mock(ExecutionContextAdapter.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.connectionProvider = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        this.configurationInstance = (ConfigurationInstance)Mockito.mock(ConfigurationInstance.class);
        Mockito.when((Object)this.configurationInstance.getConnectionProvider()).thenReturn(Optional.of(this.connectionProvider));
        Mockito.when((Object)this.configurationInstance.getValue()).thenReturn(this.config);
        Mockito.when((Object)this.connectionProvider.connect()).thenReturn((Object)connection);
        TransactionConfig transactionConfig = (TransactionConfig)Mockito.mock(TransactionConfig.class);
        Mockito.when((Object)transactionConfig.getAction()).thenReturn((Object)3);
        Mockito.when((Object)transactionConfig.isTransacted()).thenReturn((Object)true);
        Mockito.when((Object)this.operationContext.getTransactionConfig()).thenReturn(Optional.of(transactionConfig));
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (transaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(transaction);
        }
    }

    @Test
    public void xaTransaction() throws Exception {
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(this.configurationInstance));
        this.bindAndVerify();
    }

    @Test
    public void xaTransactionWithDecoratedConfig() throws Exception {
        ExecutionContextConfigurationDecorator configurationInstanceDecorator = (ExecutionContextConfigurationDecorator)Mockito.mock(ExecutionContextConfigurationDecorator.class);
        Mockito.when((Object)configurationInstanceDecorator.getDecorated()).thenReturn((Object)this.configurationInstance);
        Mockito.when((Object)configurationInstanceDecorator.getConnectionProvider()).thenReturn(Optional.of(this.connectionProvider));
        Mockito.when((Object)configurationInstanceDecorator.getValue()).thenReturn(this.config);
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(configurationInstanceDecorator));
        this.bindAndVerify();
    }

    private void bindAndVerify() throws TransactionException, ConnectionException {
        this.connectionManager.bind(this.config, this.connectionProvider);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.transaction);
        this.adapter.getConnection(this.operationContext);
        ((XaTransaction)Mockito.verify((Object)this.transaction)).bindResource(ArgumentMatchers.any(), ArgumentMatchers.any(XAExtensionTransactionalResource.class));
    }
}

