/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.module.extension.internal.runtime.resolver.HashedResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.model.HealthStatus;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
public class HashedResolverSetResultTestCase
extends AbstractMuleTestCase {
    private static final String NAME = "MG";
    private static final int AGE = 31;
    private static final HealthStatus HEALTH = null;
    private ParameterModel nameParameterModel;
    private ParameterModel ageParameterModel;
    private ParameterModel healthParameterModel;
    private ResolverSetResult result;

    @Before
    public void before() throws Exception {
        this.nameParameterModel = ExtensionsTestUtils.getParameter("myName", String.class);
        this.ageParameterModel = ExtensionsTestUtils.getParameter("age", Integer.class);
        this.healthParameterModel = ExtensionsTestUtils.getParameter("initialHealth", HealthStatus.class);
        this.result = this.buildResult();
    }

    @Test
    public void testValues() {
        this.assertResult(this.result);
    }

    @Test
    public void equals() {
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.equalTo((Object)this.buildResult()));
    }

    @Test
    public void notEquals() {
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.agelessResult())));
    }

    @Test
    public void equivalentHashCode() {
        Assert.assertThat((Object)this.result.hashCode(), (Matcher)CoreMatchers.equalTo((Object)this.buildResult().hashCode()));
    }

    @Test
    public void nonEquivalentHashCode() {
        Assert.assertThat((Object)this.result.hashCode(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.agelessResult().hashCode())));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullParameter() {
        this.getBuilder().add(null, (Object)"blah");
    }

    @Test
    public void invalidParameter() {
        Assert.assertThat((Object)this.result.get("invalid"), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void invalidParameterName() {
        Assert.assertThat((Object)this.result.get("invalid"), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    private void assertResult(ResolverSetResult result) {
        Assert.assertThat((Object)result.get(this.nameParameterModel.getName()), (Matcher)Is.is((Object)NAME));
        Assert.assertThat((Object)result.get(this.ageParameterModel.getName()), (Matcher)Is.is((Object)31));
        Assert.assertThat((Object)result.get(this.healthParameterModel.getName()), (Matcher)Is.is((Object)HEALTH));
    }

    private ResolverSetResult buildResult() {
        return this.getBuilder().build();
    }

    private ResolverSetResult agelessResult() {
        return this.getBuilder().add(this.ageParameterModel.getName(), null).build();
    }

    private ResolverSetResult.Builder getBuilder() {
        return HashedResolverSetResult.newBuilder().add(this.nameParameterModel.getName(), (Object)NAME).add(this.ageParameterModel.getName(), (Object)31).add(this.healthParameterModel.getName(), (Object)HEALTH);
    }
}

